/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.util.TimeStripUtil;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;

public final class TieredStoreRecordWithStats
extends TieredStoreRecord {
    public TieredStoreRecordWithStats(TieredStoreRecordAccessor recordAccessor) {
        super(GlobalMemoryAccessorRegistry.AMEM, recordAccessor);
    }

    @Override
    public int getMetadataSize() {
        return 28;
    }

    int getVersionOffset() {
        return this.getMetadataOffset();
    }

    int getCreationTimeOffset() {
        return this.getMetadataOffset() + 4;
    }

    int getLastAccessTimeOffset() {
        return this.getMetadataOffset() + 8;
    }

    int getLastUpdateTimeOffset() {
        return this.getMetadataOffset() + 12;
    }

    int getHitsOffset() {
        return this.getMetadataOffset() + 16;
    }

    int getLastStoredTimeOffset() {
        return this.getMetadataOffset() + 20;
    }

    int getSequenceOffset() {
        return this.getMetadataOffset() + 24;
    }

    @Override
    public long getSequence() {
        return this.readInt(this.getSequenceOffset());
    }

    @Override
    public void setSequence(long sequence) {
        this.writeInt(this.getSequenceOffset(), (int)sequence);
    }

    @Override
    public int getVersion() {
        return this.readInt(this.getVersionOffset());
    }

    @Override
    public void setVersion(int version) {
        this.writeInt(this.getVersionOffset(), version);
    }

    @Override
    public long getCreationTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(this.getCreationTimeOffset()));
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.writeInt(this.getCreationTimeOffset(), TimeStripUtil.stripBaseTime(creationTime));
    }

    @Override
    public long getLastAccessTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(this.getLastAccessTimeOffset()));
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        this.writeInt(this.getLastAccessTimeOffset(), TimeStripUtil.stripBaseTime(lastAccessTime));
    }

    @Override
    public long getLastUpdateTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(this.getLastUpdateTimeOffset()));
    }

    @Override
    public void setLastUpdateTime(long lastUpdatedTime) {
        this.writeInt(this.getLastUpdateTimeOffset(), TimeStripUtil.stripBaseTime(lastUpdatedTime));
    }

    @Override
    public int getHits() {
        return this.readInt(this.getHitsOffset());
    }

    @Override
    public void setHits(int hits) {
        this.writeInt(this.getHitsOffset(), hits);
    }

    @Override
    public long getLastStoredTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(this.getLastStoredTimeOffset()));
    }

    @Override
    public void setLastStoredTime(long lastStoredTime) {
        this.writeInt(this.getLastStoredTimeOffset(), TimeStripUtil.stripBaseTime(lastStoredTime));
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.DATA_RECORD_WITH_STATS_READER_WRITER;
    }

    @Override
    public int getRawCreationTime() {
        return this.readInt(this.getCreationTimeOffset());
    }

    @Override
    public void setRawCreationTime(int time) {
        this.writeInt(this.getCreationTimeOffset(), time);
    }

    @Override
    public int getRawLastAccessTime() {
        return this.readInt(this.getLastAccessTimeOffset());
    }

    @Override
    public void setRawLastAccessTime(int time) {
        this.writeInt(this.getLastAccessTimeOffset(), time);
    }

    @Override
    public int getRawLastUpdateTime() {
        return this.readInt(this.getLastUpdateTimeOffset());
    }

    @Override
    public void setRawLastUpdateTime(int time) {
        this.writeInt(this.getLastUpdateTimeOffset(), time);
    }

    @Override
    public int getRawLastStoredTime() {
        return this.readInt(this.getLastStoredTimeOffset());
    }

    @Override
    public void setRawLastStoredTime(int time) {
        this.writeInt(this.getLastStoredTimeOffset(), time);
    }
}

