/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.hidensity.HiDensityRecordAccessor;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.TimeStripUtil;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;

public class HDSimpleRecordWithLRUEviction
extends HDRecord
implements Record<Data> {
    static final int METADATA_SIZE = 8;
    static final int SIZE = 16;
    static final int VALUE_OFFSET = 0;
    static final int VERSION_OFFSET = 8;
    static final int LAST_ACCESS_TIME_OFFSET = 12;

    public HDSimpleRecordWithLRUEviction(HiDensityRecordAccessor recordAccessor) {
        super(GlobalMemoryAccessorRegistry.AMEM, recordAccessor);
    }

    @Override
    protected int getSizeInternal() {
        return 16;
    }

    @Override
    public int getVersion() {
        return this.readInt(8L);
    }

    @Override
    public void setVersion(int version) {
        this.writeInt(8L, version);
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.SIMPLE_DATA_RECORD_WITH_LRU_EVICTION_READER_WRITER;
    }

    @Override
    public long getLastAccessTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(12L));
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        this.writeInt(12L, TimeStripUtil.stripBaseTime(lastAccessTime));
    }

    @Override
    public int getRawLastAccessTime() {
        return this.readInt(12L);
    }

    @Override
    public void setRawLastAccessTime(int time) {
        this.writeInt(12L, time);
    }

    @Override
    public void onAccess(long now) {
        this.setLastAccessTime(now);
    }
}

