/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.nlc;

import com.hazelcast.license.nlc.BuiltInLicenseProvider;
import java.lang.reflect.Constructor;

public final class BuiltInLicenseProviderFactory {
    private static final String DEFAULT_LICENSE_PROVIDER = "com.hazelcast.license.nlc.impl.NoLicenseProvider";
    private static final String NLC_LICENSE_PROVIDER = "com.hazelcast.license.nlc.impl.NLCLicenseProvider";

    public BuiltInLicenseProvider create() {
        BuiltInLicenseProvider provider = null;
        try {
            provider = (BuiltInLicenseProvider)this.newInstance(this.getDefaultProviderClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (provider == null) {
            try {
                provider = (BuiltInLicenseProvider)this.newInstance(this.getNLCProviderClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return provider;
    }

    private <T> T newInstance(String className) {
        ClassLoader cl = BuiltInLicenseProviderFactory.class.getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        try {
            Class<?> clazz = cl == null ? Class.forName(className) : Class.forName(className, false, cl);
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getDefaultProviderClassName() {
        return DEFAULT_LICENSE_PROVIDER;
    }

    private String getNLCProviderClassName() {
        return NLC_LICENSE_PROVIDER;
    }
}

