/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.domain;

import java.io.Serializable;

public enum LicenseChannel implements Serializable
{
    LICENSE_GENERATOR(0, "Web"),
    WEB(1, "Dowload"),
    IBM(2, "IBM"),
    TRAINING(3, "Training");

    private final int code;
    private final String text;

    private LicenseChannel(int code, String text) {
        this.code = code;
        this.text = text;
    }

    public int getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public static LicenseChannel getDefault() {
        return WEB;
    }

    public static LicenseChannel getLicenseChannel(int code) {
        for (LicenseChannel licenseChannel : LicenseChannel.values()) {
            if (licenseChannel.getCode() != code) continue;
            return licenseChannel;
        }
        return null;
    }
}

