/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class TStoreUtil {
    private TStoreUtil() {
    }

    static String prettyFormatPhysical(long physicalAddress) {
        return String.format("phys:0x0%08x", physicalAddress);
    }

    static <T> boolean monotonicUpdate(T obj, AtomicLongFieldUpdater<T> fieldUpdater, long newValue) {
        return TStoreUtil.monotonicUpdate(obj, fieldUpdater, newValue, LongValueUpdateCallback.NOP_CALLBACK);
    }

    static <T> boolean monotonicUpdate(T obj, AtomicLongFieldUpdater<T> fieldUpdater, long newValue, LongValueUpdateCallback callback) {
        long oldValue;
        do {
            if ((oldValue = fieldUpdater.get(obj)) < newValue) continue;
            return false;
        } while (!fieldUpdater.compareAndSet(obj, oldValue, newValue));
        callback.onValueChange(oldValue, newValue);
        return true;
    }

    static <T> boolean monotonicUpdate(T obj, AtomicIntegerFieldUpdater<T> fieldUpdater, int newValue) {
        return TStoreUtil.monotonicUpdate(obj, fieldUpdater, newValue, IntValueUpdateCallback.NOP_CALLBACK);
    }

    static <T> boolean monotonicUpdate(T obj, AtomicIntegerFieldUpdater<T> fieldUpdater, int newValue, IntValueUpdateCallback callback) {
        int oldValue;
        do {
            if ((oldValue = fieldUpdater.get(obj)) < newValue) continue;
            return false;
        } while (!fieldUpdater.compareAndSet(obj, oldValue, newValue));
        callback.onValueChange(oldValue, newValue);
        return true;
    }

    static boolean monotonicUpdateNativeInt(long address, int newValue) {
        int oldValue;
        do {
            if ((oldValue = GlobalMemoryAccessorRegistry.AMEM.getIntVolatile(address)) < newValue) continue;
            return false;
        } while (!GlobalMemoryAccessorRegistry.AMEM.compareAndSwapInt(address, oldValue, newValue));
        return true;
    }

    static long align8Bytes(long address) {
        return address + (8L - (address & 7L) & 7L);
    }

    static int padTo8Bytes(int size) {
        return size + (8 - (size & 7) & 7);
    }

    static String hybridLogStr(String hybridLogId) {
        return "HybridLog '" + hybridLogId + "'";
    }

    static void zeroBlock(long physicalAddress, int size) {
        GlobalMemoryAccessorRegistry.AMEM.setMemory(physicalAddress, size, (byte)0);
    }

    static interface LongValueUpdateCallback {
        public static final LongValueUpdateCallback NOP_CALLBACK = (oldValue, newValue) -> {};

        public void onValueChange(long var1, long var3);
    }

    static interface IntValueUpdateCallback {
        public static final IntValueUpdateCallback NOP_CALLBACK = (oldValue, newValue) -> {};

        public void onValueChange(int var1, int var2);
    }
}

