/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.tstore.device.DeviceOperation;
import com.hazelcast.internal.tstore.device.DeviceOperationExecutor;
import com.hazelcast.internal.tstore.device.ImmutableOperation;
import com.hazelcast.internal.tstore.device.MutableOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;

public final class DeviceOperationExecutorImpl
implements DeviceOperationExecutor {
    static final String READER_THREAD_NAME_PREFIX = "Device reader thread: ";
    static final String WRITER_THREAD_NAME_PREFIX = "Device writer thread: ";
    private static final ILogger LOGGER = Logger.getLogger(DeviceOperationExecutorImpl.class);
    private final DeviceFlusher[] writeIoThreads;
    private final DeviceReader[] readIoThreads;
    private final BlockingQueue<MutableOperation> writeQueue;
    private final BlockingQueue<ImmutableOperation> readQueue;
    private final int writePageSize;
    private final int readPageSize;

    public DeviceOperationExecutorImpl(int writeIOThreadCount, int readIOThreadCount, int maxPendingOps, int readPageSize, int writePageSize, String deviceName) {
        int i;
        assert (writeIOThreadCount > 0 && readIOThreadCount > 0);
        assert (maxPendingOps > 0);
        assert (writePageSize > 0);
        assert (deviceName != null);
        this.writeIoThreads = new DeviceFlusher[writeIOThreadCount];
        this.readIoThreads = new DeviceReader[readIOThreadCount];
        this.writeQueue = new LinkedBlockingQueue<MutableOperation>(maxPendingOps);
        this.readQueue = new LinkedBlockingQueue<ImmutableOperation>(maxPendingOps);
        this.readPageSize = readPageSize;
        this.writePageSize = writePageSize;
        for (i = 0; i < writeIOThreadCount; ++i) {
            DeviceFlusher flusher = new DeviceFlusher(deviceName, i);
            flusher.start();
            this.writeIoThreads[i] = flusher;
        }
        for (i = 0; i < readIOThreadCount; ++i) {
            DeviceReader reader = new DeviceReader(deviceName, i);
            reader.start();
            this.readIoThreads[i] = reader;
        }
    }

    @Override
    public <R> CompletableFuture<R> submit(DeviceOperation<R> op) {
        if (op instanceof MutableOperation) {
            while (!this.writeQueue.offer((MutableOperation)op)) {
                Thread.yield();
            }
        } else {
            while (!this.readQueue.offer((ImmutableOperation)op)) {
                Thread.yield();
            }
        }
        return op.getFuture();
    }

    @Override
    public void shutdown() {
        Arrays.stream(this.writeIoThreads).forEach(DeviceThread::terminate);
        Arrays.stream(this.readIoThreads).forEach(DeviceThread::terminate);
    }

    private static String buildReaderThreadName(String deviceName, int threadId) {
        StringBuilder threadName = new StringBuilder(READER_THREAD_NAME_PREFIX);
        threadName.append(threadId);
        threadName.append(" on ");
        threadName.append(deviceName);
        return threadName.toString();
    }

    private static String buildFlusherThreadName(String deviceName, int id) {
        StringBuilder threadName = new StringBuilder(WRITER_THREAD_NAME_PREFIX);
        threadName.append(id);
        threadName.append(" on ");
        threadName.append(deviceName);
        return threadName.toString();
    }

    abstract class DeviceThread
    implements Runnable {
        private final Thread thread;
        private volatile boolean terminated;

        DeviceThread(String threadName) {
            this.thread = new Thread((Runnable)this, threadName);
        }

        void start() {
            this.thread.start();
        }

        abstract DeviceOperation takeOperation() throws InterruptedException;

        abstract void executeOp(DeviceOperation var1);

        @Override
        public void run() {
            try {
                while (!this.terminated) {
                    try {
                        DeviceOperation op = this.takeOperation();
                        this.executeOp(op);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Throwable t) {
                OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(t);
                LOGGER.severe(t);
            }
        }

        void terminate() {
            this.terminated = true;
            this.thread.interrupt();
            this.join();
        }

        private void join() {
            boolean interrupted = false;
            while (true) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private final class DeviceFlusher
    extends DeviceThread {
        private final byte[] pageData;

        DeviceFlusher(String deviceName, int id) {
            super(DeviceOperationExecutorImpl.buildFlusherThreadName(deviceName, id));
            this.pageData = new byte[DeviceOperationExecutorImpl.this.writePageSize];
        }

        @Override
        DeviceOperation takeOperation() throws InterruptedException {
            return (DeviceOperation)DeviceOperationExecutorImpl.this.writeQueue.take();
        }

        @Override
        void executeOp(DeviceOperation op) {
            CompletableFuture opFuture = ((MutableOperation)op).getFuture();
            try {
                op.run(this.pageData);
                opFuture.complete(null);
            }
            catch (Throwable t) {
                opFuture.completeExceptionally(t);
                LOGGER.warning("Exception executing operation " + op, t);
            }
        }
    }

    private final class DeviceReader
    extends DeviceThread {
        private final byte[] recordPartBuf;

        DeviceReader(String deviceName, int id) {
            super(DeviceOperationExecutorImpl.buildReaderThreadName(deviceName, id));
            this.recordPartBuf = new byte[DeviceOperationExecutorImpl.this.readPageSize];
        }

        @Override
        DeviceOperation takeOperation() throws InterruptedException {
            return (DeviceOperation)DeviceOperationExecutorImpl.this.readQueue.take();
        }

        @Override
        void executeOp(DeviceOperation op) {
            ImmutableOperation imOp = (ImmutableOperation)op;
            CompletableFuture opFuture = imOp.getFuture();
            try {
                byte[] buf = imOp.getReadLength() > 0 ? new byte[imOp.getReadLength()] : this.recordPartBuf;
                byte[] res = (byte[])imOp.run(buf);
                if (res == this.recordPartBuf) {
                    byte[] copyRes = new byte[res.length];
                    System.arraycopy(res, 0, copyRes, 0, res.length);
                    opFuture.complete(copyRes);
                    return;
                }
                opFuture.complete(res);
            }
            catch (Throwable t) {
                opFuture.completeExceptionally(t);
                LOGGER.warning("Exception executing operation " + op, t);
            }
        }
    }
}

