/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.compaction.CompactorFutureTask;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class CompactionStats {
    private static final boolean IS_AUTOMATIC_COMPACTION_DISABLED = Boolean.getBoolean("disableTieredStoreCompaction");
    private static final boolean ALWAYS_RUN_FULL_COMPACTION = false;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final List<Device>[] partitionDevices;
    private final CompactionManager compactionManager;
    private final AtomicInteger numSegmentsOnDevice = new AtomicInteger();
    private final AtomicBoolean isCompactionOnGoing = new AtomicBoolean();
    private final int deviceCapacitySegments;

    public CompactionStats(CompactionManager compactionManager, long deviceCapacityBytes, int partitionCnt) {
        this.compactionManager = compactionManager;
        this.deviceCapacitySegments = (int)(deviceCapacityBytes / 0x4000000L / 2L);
        List[] devices = new List[partitionCnt];
        for (int i = 0; i < partitionCnt; ++i) {
            devices[i] = new ArrayList(1);
        }
        this.partitionDevices = devices;
    }

    public void registerDevice(Device device) {
        int partitionId = device.partitionId();
        this.writeLock.lock();
        try {
            this.partitionDevices[partitionId].add(device);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterDevice(Device device) {
        this.writeLock.lock();
        try {
            List<Device> devices = this.partitionDevices[device.partitionId()];
            int idx = devices.indexOf(device);
            if (idx == devices.size() - 1) {
                devices.remove(idx);
                return;
            }
            Collections.swap(devices, idx, devices.size() - 1);
            devices.remove(devices.size() - 1);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void onNewSegment() {
        if (this.numSegmentsOnDevice.incrementAndGet() < this.deviceCapacitySegments) {
            return;
        }
        this.checkForCompaction();
    }

    public void compactSegment(TStoreUserId userId, int partitionId, int segmentNo) {
        Invariants.isFalse(this.isAutomaticCompactionDisabled(), "segments cannot be scheduled for compaction while automatic compaction has been disabled.");
        this.compactionManager.runCompactionIncremental(userId, partitionId, segmentNo);
        this.numSegmentsOnDevice.decrementAndGet();
    }

    public boolean isAutomaticCompactionDisabled() {
        return IS_AUTOMATIC_COMPACTION_DISABLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForCompaction() {
        if (this.isAutomaticCompactionDisabled()) {
            return;
        }
        if (this.isCompactionOnGoing.getAndSet(true)) {
            return;
        }
        this.readLock.lock();
        try {
            int count = this.numSegmentsOnDevice.get();
            while (count > 0) {
                for (List<Device> devices : this.partitionDevices) {
                    for (Device device : devices) {
                        int segmentNo = device.nextSegmentForCompactionOrMinus1();
                        if (segmentNo == -1) continue;
                        this.compactionManager.runCompactionIncremental(device.userId(), device.partitionId(), segmentNo);
                        this.numSegmentsOnDevice.decrementAndGet();
                        --count;
                    }
                }
            }
        }
        finally {
            this.readLock.unlock();
            boolean oldValue = this.isCompactionOnGoing.getAndSet(false);
            assert (oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CompactorFutureTask> triggerLogBasedCompaction(int partitionId) {
        this.readLock.lock();
        try {
            ArrayList<CompactorFutureTask> futures = new ArrayList<CompactorFutureTask>();
            List<Device> devices = this.partitionDevices[partitionId];
            for (Device device : devices) {
                int segmentNo;
                while ((segmentNo = device.nextSegmentForCompactionOrMinus1()) != -1) {
                    Invariants.equals(partitionId, device.partitionId());
                    futures.add((CompactorFutureTask)this.compactionManager.runCompactionIncremental(device.userId(), device.partitionId(), segmentNo));
                }
            }
            ArrayList<CompactorFutureTask> arrayList = futures;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CompactorFutureTask> triggerIndexBasedCompaction(int partitionId) {
        this.readLock.lock();
        try {
            List<Device> devices = this.partitionDevices[partitionId];
            ArrayList<CompactorFutureTask> futures = new ArrayList<CompactorFutureTask>(devices.size());
            for (Device device : devices) {
                Invariants.equals(partitionId, device.partitionId());
                futures.add((CompactorFutureTask)this.compactionManager.runCompactionFull(device.userId(), device.partitionId()));
            }
            ArrayList<CompactorFutureTask> arrayList = futures;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

