/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.EnterpriseClusterVersionAware;
import com.hazelcast.internal.serialization.impl.EnterpriseDataSerializableHeader;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.serialization.TypedDataSerializable;
import com.hazelcast.nio.serialization.TypedStreamDeserializer;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.nio.serialization.impl.VersionedDataSerializableFactory;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public final class EnterpriseDataSerializableSerializer
implements StreamSerializer<DataSerializable>,
TypedStreamDeserializer<DataSerializable> {
    private static final String FACTORY_ID = "com.hazelcast.DataSerializerHook";
    private static final String COMPATIBILITY_FACTORY_ID = "com.hazelcast.CompatibilityDataSerializerHook";
    private final Int2ObjectHashMap<DataSerializableFactory> factories = new Int2ObjectHashMap();
    private final EnterpriseClusterVersionAware clusterVersionAware;

    EnterpriseDataSerializableSerializer(Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories, ClassLoader classLoader, EnterpriseClusterVersionAware clusterVersionAware, boolean isCompatibility) {
        this.clusterVersionAware = clusterVersionAware;
        try {
            String factoryId = isCompatibility ? COMPATIBILITY_FACTORY_ID : FACTORY_ID;
            Iterator<DataSerializerHook> hooks = ServiceLoader.iterator(DataSerializerHook.class, factoryId, classLoader);
            while (hooks.hasNext()) {
                DataSerializerHook hook = hooks.next();
                DataSerializableFactory factory = hook.createFactory();
                if (factory == null) continue;
                this.register(hook.getFactoryId(), factory);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        if (dataSerializableFactories != null) {
            for (Map.Entry<Integer, ? extends DataSerializableFactory> entry : dataSerializableFactories.entrySet()) {
                this.register(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void register(int factoryId, DataSerializableFactory factory) {
        DataSerializableFactory current = this.factories.get(factoryId);
        if (current != null) {
            if (!current.equals(factory)) throw new IllegalArgumentException("DataSerializableFactory[" + factoryId + "] is already registered! " + current + " -> " + factory);
            Logger.getLogger(this.getClass()).warning("DataSerializableFactory[" + factoryId + "] is already registered! Skipping " + factory);
            return;
        } else {
            this.factories.put(factoryId, factory);
        }
    }

    @Override
    public void destroy() {
        this.factories.clear();
    }

    @Override
    public int getTypeId() {
        return -2;
    }

    @Override
    public DataSerializable read(ObjectDataInput in, Class clazz) throws IOException {
        DataSerializable instance = null;
        if (null != clazz) {
            try {
                instance = (DataSerializable)clazz.newInstance();
            }
            catch (Exception e) {
                throw new HazelcastSerializationException("Requested class " + clazz + " could not be instantiated.", e);
            }
        }
        return this.doRead(in, instance);
    }

    @Override
    public DataSerializable read(ObjectDataInput in) throws IOException {
        return this.doRead(in, null);
    }

    private DataSerializable doRead(ObjectDataInput in, DataSerializable instance) throws IOException {
        byte header = in.readByte();
        if (EnterpriseDataSerializableHeader.isIdentifiedDataSerializable(header)) {
            return this.readIdentifiedDataSerializable(in, header, instance);
        }
        return this.readDataSerializable(in, header, instance);
    }

    private DataSerializable readIdentifiedDataSerializable(ObjectDataInput in, byte header, DataSerializable instance) throws IOException {
        int factoryId = 0;
        int classId = 0;
        try {
            factoryId = in.readInt();
            classId = in.readInt();
            Version previousClusterVersion = in.getVersion();
            Version previousWanProtocolVersion = in.getWanProtocolVersion();
            if (EnterpriseDataSerializableHeader.isVersioned(header)) {
                this.readVersions(in);
            } else {
                in.setVersion(Version.UNKNOWN);
                in.setWanProtocolVersion(Version.UNKNOWN);
            }
            DataSerializable ds = instance != null ? instance : this.createIdentifiedDataSerializable(in.getVersion(), in.getWanProtocolVersion(), factoryId, classId);
            ds.readData(in);
            in.setVersion(previousClusterVersion);
            in.setWanProtocolVersion(previousWanProtocolVersion);
            return ds;
        }
        catch (Exception ex) {
            throw EnterpriseDataSerializableSerializer.rethrowIdsReadException(factoryId, classId, ex);
        }
    }

    private void readVersions(ObjectDataInput in) throws IOException {
        byte major = in.readByte();
        byte minor = in.readByte();
        assert (this.clusterVersionAware.getClusterVersion() != null);
        if (major < 0) {
            in.setWanProtocolVersion(Version.of(-major, minor));
        } else {
            in.setVersion(Version.of(major, minor));
        }
    }

    private DataSerializable createIdentifiedDataSerializable(Version clusterVersion, Version wanProtocolVersion, int factoryId, int classId) {
        DataSerializableFactory dsf = this.factories.get(factoryId);
        if (dsf == null) {
            throw new HazelcastSerializationException("No DataSerializerFactory registered for namespace: " + factoryId);
        }
        if (dsf instanceof VersionedDataSerializableFactory) {
            return ((VersionedDataSerializableFactory)dsf).create(classId, clusterVersion, wanProtocolVersion);
        }
        return dsf.create(classId);
    }

    private DataSerializable readDataSerializable(ObjectDataInput in, byte header, DataSerializable instance) throws IOException {
        String className = in.readString();
        try {
            Version previousClusterVersion = in.getVersion();
            Version previousWanProtocolVersion = in.getWanProtocolVersion();
            if (EnterpriseDataSerializableHeader.isVersioned(header)) {
                this.readVersions(in);
            } else {
                in.setVersion(Version.UNKNOWN);
                in.setWanProtocolVersion(Version.UNKNOWN);
            }
            DataSerializable ds = instance != null ? instance : (DataSerializable)ClassLoaderUtil.newInstance(in.getClassLoader(), className);
            ds.readData(in);
            in.setVersion(previousClusterVersion);
            in.setWanProtocolVersion(previousWanProtocolVersion);
            return ds;
        }
        catch (Exception ex) {
            throw EnterpriseDataSerializableSerializer.rethrowDsReadException(className, ex);
        }
    }

    @Override
    public void write(ObjectDataOutput out, DataSerializable obj) throws IOException {
        Version previousClusterVersion = out.getVersion();
        if (out.getWanProtocolVersion() == Version.UNKNOWN) {
            Version version = obj instanceof Versioned ? this.clusterVersionAware.getClusterVersion() : Version.UNKNOWN;
            out.setVersion(version);
        }
        if (obj instanceof IdentifiedDataSerializable) {
            this.writeIdentifiedDataSerializable(out, (IdentifiedDataSerializable)obj, out.getVersion(), out.getWanProtocolVersion());
        } else {
            this.writeDataSerializable(out, obj, out.getVersion(), out.getWanProtocolVersion());
        }
        obj.writeData(out);
        if (out.getWanProtocolVersion() == Version.UNKNOWN) {
            out.setVersion(previousClusterVersion);
        }
    }

    private void writeIdentifiedDataSerializable(ObjectDataOutput out, IdentifiedDataSerializable obj, Version clusterVersion, Version wanProtocolVersion) throws IOException {
        boolean versioned = clusterVersion != Version.UNKNOWN || wanProtocolVersion != Version.UNKNOWN;
        out.writeByte(EnterpriseDataSerializableHeader.createHeader(true, versioned));
        out.writeInt(obj.getFactoryId());
        out.writeInt(obj.getClassId());
        if (wanProtocolVersion != Version.UNKNOWN) {
            out.writeByte(-wanProtocolVersion.getMajor());
            out.writeByte(wanProtocolVersion.getMinor());
        } else if (clusterVersion != Version.UNKNOWN) {
            out.writeByte(clusterVersion.getMajor());
            out.writeByte(clusterVersion.getMinor());
        }
    }

    private void writeDataSerializable(ObjectDataOutput out, DataSerializable obj, Version clusterVersion, Version wanProtocolVersion) throws IOException {
        boolean versioned = clusterVersion != Version.UNKNOWN || wanProtocolVersion != Version.UNKNOWN;
        out.writeByte(EnterpriseDataSerializableHeader.createHeader(false, versioned));
        if (obj instanceof TypedDataSerializable) {
            out.writeString(((TypedDataSerializable)obj).getClassType().getName());
        } else {
            out.writeString(obj.getClass().getName());
        }
        if (wanProtocolVersion != Version.UNKNOWN) {
            out.writeByte(-wanProtocolVersion.getMajor());
            out.writeByte(wanProtocolVersion.getMinor());
        } else if (clusterVersion != Version.UNKNOWN) {
            out.writeByte(clusterVersion.getMajor());
            out.writeByte(clusterVersion.getMinor());
        }
    }

    private static IOException rethrowIdsReadException(int factoryId, int classId, Exception e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof HazelcastSerializationException) {
            throw (HazelcastSerializationException)e;
        }
        throw new HazelcastSerializationException("Problem while reading IdentifiedDataSerializable, namespace: " + factoryId + ", classId: " + classId + ", exception: " + e.getMessage(), e);
    }

    private static IOException rethrowDsReadException(String className, Exception e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof HazelcastSerializationException) {
            throw (HazelcastSerializationException)e;
        }
        throw new HazelcastSerializationException("Problem while reading DataSerializable, class-name: " + className + ", exception: " + e.getMessage(), e);
    }
}

