/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.memory.DefaultMemoryStats;
import com.hazelcast.internal.memory.MemoryAdjuster;
import com.hazelcast.memory.MemorySize;
import java.util.concurrent.atomic.AtomicLong;

class NativeMemoryStats
extends DefaultMemoryStats {
    private static final boolean ASSERTS_ENABLED = NativeMemoryStats.class.desiredAssertionStatus();
    protected final AtomicLong committedNative = new AtomicLong();
    private final long configuredMaxNative;
    private final AtomicLong maxNative;
    private final AtomicLong internalFragmentation = new AtomicLong();
    private final MemoryAdjuster memoryAdjuster;

    NativeMemoryStats(long maxNative) {
        this.maxNative = new AtomicLong(maxNative);
        this.configuredMaxNative = maxNative;
        this.memoryAdjuster = new MemoryAdjuster(this);
    }

    public MemoryAdjuster getMemoryAdjuster() {
        return this.memoryAdjuster;
    }

    @Override
    public final long getMaxNative() {
        return this.maxNative.get();
    }

    public boolean casMaxNative(long currentAllocated, long memoryAfterAllocation) {
        return this.maxNative.compareAndSet(currentAllocated, memoryAfterAllocation);
    }

    public long getConfiguredMaxNative() {
        return this.configuredMaxNative;
    }

    @Override
    public final long getCommittedNative() {
        return this.committedNative.get();
    }

    public boolean casCommittedNative(long currentAllocated, long memoryAfterAllocation) {
        return this.committedNative.compareAndSet(currentAllocated, memoryAfterAllocation);
    }

    @Override
    public long getUsedNative() {
        return this.getCommittedNative();
    }

    @Override
    public final long getFreeNative() {
        long free = this.getMaxNative() - this.getUsedNative();
        return free > 0L ? free : 0L;
    }

    final void removeCommittedNative(long size) {
        this.committedNative.addAndGet(-size);
    }

    final void addInternalFragmentation(long size) {
        if (ASSERTS_ENABLED) {
            this.internalFragmentation.addAndGet(size);
        }
    }

    final void removeInternalFragmentation(long size) {
        if (ASSERTS_ENABLED) {
            this.internalFragmentation.addAndGet(-size);
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NativeMemoryStats{");
        sb.append("Total Physical: ").append(MemorySize.toPrettyString(this.getTotalPhysical()));
        sb.append(", Free Physical: ").append(MemorySize.toPrettyString(this.getFreePhysical()));
        sb.append(", Max Heap: ").append(MemorySize.toPrettyString(this.getMaxHeap()));
        sb.append(", Committed Heap: ").append(MemorySize.toPrettyString(this.getCommittedHeap()));
        sb.append(", Used Heap: ").append(MemorySize.toPrettyString(this.getUsedHeap()));
        sb.append(", Free Heap: ").append(MemorySize.toPrettyString(this.getFreeHeap()));
        sb.append(", Max Native Memory: ").append(MemorySize.toPrettyString(this.getMaxNative()));
        sb.append(", Committed Native Memory: ").append(MemorySize.toPrettyString(this.getCommittedNative()));
        sb.append(", Used Native Memory: ").append(MemorySize.toPrettyString(this.getUsedNative()));
        sb.append(", Free Native Memory: ").append(MemorySize.toPrettyString(this.getFreeNative()));
        this.appendAdditionalToString(sb);
        if (ASSERTS_ENABLED) {
            sb.append(", Internal Fragmentation: ").append(MemorySize.toPrettyString(this.internalFragmentation.get()));
        }
        sb.append(", GC Stats: ");
        sb.append(this.getGCStats());
        sb.append('}');
        return sb.toString();
    }

    void appendAdditionalToString(StringBuilder sb) {
    }
}

