/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.memory.MemoryStatsSupport;
import com.hazelcast.memory.MemorySize;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;

public final class FreeMemoryChecker {
    public static final String HIDENSITY_CHECK_FREEMEMORY = "hazelcast.hidensity.check.freememory";
    public static final HazelcastProperty FREE_MEMORY_CHECKER_ENABLED = new HazelcastProperty("hazelcast.hidensity.check.freememory", true);
    private final boolean enabled;

    public FreeMemoryChecker() {
        String enabledStr = FREE_MEMORY_CHECKER_ENABLED.getSystemProperty();
        this.enabled = Boolean.parseBoolean(enabledStr != null ? enabledStr : "true");
    }

    public FreeMemoryChecker(HazelcastProperties properties) {
        this.enabled = properties.getBoolean(FREE_MEMORY_CHECKER_ENABLED);
    }

    public void checkFreeMemory(long size) {
        if (!this.enabled) {
            return;
        }
        long totalMem = MemoryStatsSupport.totalPhysicalMemory();
        if (totalMem < 0L) {
            return;
        }
        long freeMem = MemoryStatsSupport.freePhysicalMemory();
        if (freeMem < 0L) {
            return;
        }
        if (size > freeMem) {
            throw new NativeOutOfMemoryError(String.format("Not enough free physical memory available! Cannot allocate %s! Total physical memory: %s Free physical memory: %s%nDepending on the operating system or virtualization technology the memory check may report incorrect total or free amount of memory.%nYou can disable the check by adding the following runtime switch '-Dhazelcast.hidensity.check.freememory=false'", MemorySize.toPrettyString(size), MemorySize.toPrettyString(totalMem), MemorySize.toPrettyString(freeMem)));
        }
    }
}

