/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.record;

import com.hazelcast.internal.hotrestart.RecordDataSink;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.QuickMath;
import java.nio.ByteBuffer;

public final class RecordDataHolder
implements RecordDataSink {
    public static final int INITIAL_BUFSIZE = 64;
    public ByteBuffer keyBuffer = ByteBuffer.allocate(64);
    public ByteBuffer valueBuffer = ByteBuffer.allocate(64);

    @Override
    public ByteBuffer getKeyBuffer(int keySize) {
        this.keyBuffer = RecordDataHolder.ensureBufferCapacity(this.keyBuffer, keySize);
        return this.keyBuffer;
    }

    @Override
    public ByteBuffer getValueBuffer(int valueSize) {
        this.valueBuffer = RecordDataHolder.ensureBufferCapacity(this.valueBuffer, valueSize);
        return this.valueBuffer;
    }

    public void clear() {
        JVMUtil.upcast(this.keyBuffer).clear();
        JVMUtil.upcast(this.valueBuffer).clear();
    }

    public void flip() {
        JVMUtil.upcast(this.keyBuffer).flip();
        JVMUtil.upcast(this.valueBuffer).flip();
    }

    private static ByteBuffer ensureBufferCapacity(ByteBuffer buf, int capacity) {
        return buf.capacity() >= capacity ? buf : ByteBuffer.allocate(QuickMath.nextPowerOfTwo(capacity));
    }
}

