/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.HotRestartKey;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcMainLoop;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.ActiveChunk;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyorSingleQueue;
import java.io.File;

public class GcExecutor {
    public static final int COLLECTOR_QUEUE_CAPACITY = 1024;
    private final ChunkManager chunkMgr;
    private final Object testGcMutex;
    private final ConcurrentConveyorSingleQueue<Runnable> conveyor;
    private final Thread gcThread;
    private final MutatorCatchup mc;

    @Inject
    GcExecutor(@Name(value="gcConveyor") ConcurrentConveyorSingleQueue<Runnable> gcConveyor, ChunkManager chunkMgr, MutatorCatchup mc, GcMainLoop mainLoop, @Name(value="storeName") String storeName, @Name(value="testGcMutex") Object testGcMutex) {
        this.chunkMgr = chunkMgr;
        this.gcThread = new Thread((Runnable)mainLoop, storeName + ".GC-thread");
        this.conveyor = gcConveyor;
        this.mc = mc;
        this.testGcMutex = testGcMutex;
    }

    public void start() {
        this.gcThread.start();
    }

    public void shutdown() {
        this.conveyor.submit(new Runnable(){

            @Override
            public void run() {
                ((GcExecutor)GcExecutor.this).mc.askedToStop = true;
            }
        });
        this.conveyor.awaitDrainerGone();
    }

    public void submitRecord(HotRestartKey key, long freshSeq, int freshSize, boolean freshIsTombstone) {
        ChunkManager chunkManager = this.chunkMgr;
        chunkManager.getClass();
        this.conveyor.submit(chunkManager.new ChunkManager.AddRecord(key, freshSeq, freshSize, freshIsTombstone));
    }

    public void submitReplaceActiveChunk(ActiveChunk closed, ActiveChunk fresh) {
        ChunkManager chunkManager = this.chunkMgr;
        chunkManager.getClass();
        this.conveyor.submit(chunkManager.new ChunkManager.ReplaceActiveChunk(fresh, closed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhileGcPaused(MutatorCatchup.CatchupRunnable task) {
        Object object = this.testGcMutex;
        synchronized (object) {
            task.run(this.mc);
        }
    }

    public void submitBackup(File targetDir) {
        ChunkManager chunkManager = this.chunkMgr;
        chunkManager.getClass();
        this.conveyor.submit(chunkManager.new ChunkManager.BackupChunks(targetDir));
    }
}

