/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Member;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.hotrestart.cluster.AbstractMetadataWriter;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

class MemberListWriter
extends AbstractMetadataWriter<Collection<Member>> {
    static final String FILE_NAME = "members.bin";
    private Node node;

    MemberListWriter(File homeDir, Node node) {
        super(homeDir);
        this.node = node;
    }

    @Override
    synchronized void doWrite(DataOutput out, Collection<Member> members) throws IOException {
        this.writeMember(out, this.node.getLocalMember());
        out.writeInt(members.size());
        for (Member member : members) {
            this.writeMember(out, member);
        }
    }

    private void writeMember(DataOutput out, Member member) throws IOException {
        UUIDSerializationUtil.writeUUID(out, member.getUuid());
        MemberListWriter.writeAddress(out, member.getAddress());
        out.writeBoolean(member.localMember());
        out.writeUTF(member.getVersion().toString());
    }

    @Override
    String getFilename() {
        return FILE_NAME;
    }
}

