/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.hotrestart.cluster.AbstractMetadataReader;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.version.MemberVersion;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;

class MemberListReader
extends AbstractMetadataReader {
    MemberImpl localMember;
    private Collection<MemberImpl> members = Collections.emptySet();

    MemberListReader(File homeDir) {
        super(homeDir);
    }

    @Override
    void doRead(DataInput in) throws IOException {
        this.localMember = MemberListReader.readMember(in);
        int size = in.readInt();
        this.members = new HashSet<MemberImpl>(size);
        for (int i = 0; i < size; ++i) {
            MemberImpl member = MemberListReader.readMember(in);
            this.members.add(member);
        }
    }

    static MemberImpl readMember(DataInput in) throws IOException {
        UUID uuid = UUIDSerializationUtil.readUUID(in);
        Address address = MemberListReader.readAddress(in);
        boolean localMember = in.readBoolean();
        MemberVersion version = MemberVersion.of(in.readUTF());
        return new MemberImpl.Builder(address).version(version).localMember(localMember).uuid(uuid).build();
    }

    @Override
    String getFilename() {
        return "members.bin";
    }

    MemberImpl getLocalMember() {
        return this.localMember;
    }

    Collection<MemberImpl> getMembers() {
        return this.members;
    }
}

