/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.internal.hotrestart.cluster.AbstractMetadataReader;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldKind;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class CompactSchemaReader
extends AbstractMetadataReader {
    private Collection<Schema> schemas = Collections.emptyList();

    CompactSchemaReader(File homeDir) {
        super(homeDir);
    }

    public Collection<Schema> getSchemas() {
        return this.schemas;
    }

    @Override
    String getFilename() {
        return "compact-schemas.bin";
    }

    @Override
    void doRead(DataInput in) throws IOException {
        int schemaCount = in.readInt();
        ArrayList<Schema> schemas = new ArrayList<Schema>(schemaCount);
        for (int i = 0; i < schemaCount; ++i) {
            String typeName = in.readUTF();
            int fieldCount = in.readInt();
            ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>(fieldCount);
            for (int j = 0; j < fieldCount; ++j) {
                String name = in.readUTF();
                FieldKind kind = FieldKind.get(in.readInt());
                FieldDescriptor descriptor = new FieldDescriptor(name, kind);
                fields.add(descriptor);
            }
            Schema schema = new Schema(typeName, fields);
            schemas.add(schema);
        }
        this.schemas = schemas;
    }
}

