/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hidensity.impl;

import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.tstore.hybridlog.AddressRemapper;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.map.impl.record.TieredStoreChunkAccessor;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.TieredStoreSlotAccessor;

public class TieredStoreRecordProcessor
implements HiDensityRecordProcessor<TieredStoreRecord> {
    public static final AddressRemapper<TieredStoreRecord> NOP_REMAPPER = (record, oldLogicalAddress, newLogicalAddress) -> newLogicalAddress;
    private final EnterpriseSerializationService serializationService;
    private final TieredStoreRecordAccessor recordAccessor;
    private final HiDensityStorageInfo storageInfo;

    public TieredStoreRecordProcessor(EnterpriseSerializationService serializationService, TieredStoreRecordAccessor recordAccessor, HiDensityStorageInfo storageInfo) {
        this.serializationService = serializationService;
        this.recordAccessor = recordAccessor;
        this.storageInfo = storageInfo;
    }

    public EnterpriseSerializationService getSerializationService() {
        return this.serializationService;
    }

    public TieredStoreRecord newPreparedRecord(int recordSize) {
        TieredStoreRecord record = this.newRecord();
        HybridLog hybridLog = this.recordAccessor.getHybridLog();
        long logicalAddress = hybridLog.allocate(recordSize);
        long physicalAddress = hybridLog.asPhysicalAddress(logicalAddress);
        this.storageInfo.addUsedMemory(recordSize);
        record.reset(physicalAddress, logicalAddress, recordSize);
        return record;
    }

    public TieredStoreRecord readRecordForReadOnly(long recordLogicalAddress, AddressRemapper<TieredStoreRecord> addressUpdater) {
        return this.readRecord(recordLogicalAddress, addressUpdater, false);
    }

    public TieredStoreRecord readRecordForUpdate(long recordLogicalAddress, AddressRemapper<TieredStoreRecord> addressUpdater) {
        return this.readRecord(recordLogicalAddress, addressUpdater, true);
    }

    private TieredStoreRecord readRecord(long recordLogicalAddress, AddressRemapper<TieredStoreRecord> addressUpdater, boolean forUpdate) {
        HybridLog hybridLog = this.recordAccessor.getHybridLog();
        TieredStoreSlotAccessor slotAccessor = this.recordAccessor.getTieredStoreSlotAccessor();
        while (true) {
            long readRecordLogicalAddress;
            TieredStoreRecord readRecord;
            boolean createdNewCopy = forUpdate && !hybridLog.isMutable(recordLogicalAddress) || !hybridLog.isInMemory(recordLogicalAddress);
            TieredStoreRecord tieredStoreRecord = readRecord = forUpdate ? hybridLog.readRecordForUpdate(recordLogicalAddress, slotAccessor, NOP_REMAPPER) : hybridLog.readRecordForReadOnly(recordLogicalAddress, slotAccessor, NOP_REMAPPER);
            if (createdNewCopy) {
                this.recordAccessor.setDummy(readRecord);
            }
            if ((readRecordLogicalAddress = readRecord.getLogicalAddress()) == recordLogicalAddress) {
                return readRecord;
            }
            long remappedRecordLogicalAddress = addressUpdater.remap(readRecord, recordLogicalAddress, readRecordLogicalAddress);
            if (hybridLog.isInMemory(remappedRecordLogicalAddress)) {
                if (remappedRecordLogicalAddress != readRecordLogicalAddress) {
                    this.recordAccessor.setDummy(readRecord);
                    long newPhysicalAddress = hybridLog.asPhysicalAddress(remappedRecordLogicalAddress);
                    return this.newRecord().reset(newPhysicalAddress, remappedRecordLogicalAddress, -1);
                }
            } else {
                recordLogicalAddress = remappedRecordLogicalAddress;
                continue;
            }
            if (hybridLog.isInMemory(readRecordLogicalAddress)) {
                return readRecord;
            }
            recordLogicalAddress = readRecordLogicalAddress;
        }
    }

    public byte[] readRecordFromDevice(long recordLogicalAddress) {
        assert (!this.getHybridLog().isInMemory(recordLogicalAddress));
        TieredStoreSlotAccessor slotAccessor = this.recordAccessor.getTieredStoreSlotAccessor();
        return this.getHybridLog().readRecordFromDevice(recordLogicalAddress, slotAccessor);
    }

    public Data readRecordValueFromDevice(long recordLogicalAddress, int valueOffset, byte[] buf) {
        assert (!this.getHybridLog().isInMemory(recordLogicalAddress));
        TieredStoreChunkAccessor chunkAccessor = this.recordAccessor.getTieredStoreChunkAccessor();
        byte[] payload = this.getHybridLog().readChunk(recordLogicalAddress + (long)valueOffset, buf, chunkAccessor);
        return new HeapData(payload);
    }

    public Data readRecordValueFromDevice(long recordLogicalAddress, Data key, byte[] buf) {
        assert (!this.getHybridLog().isInMemory(recordLogicalAddress));
        int valueOffset = 16 + key.totalSize();
        return this.readRecordValueFromDevice(recordLogicalAddress, valueOffset, buf);
    }

    public int recordSize(Data key, Data dataValue, int metadataSize) {
        return this.recordAccessor.recordSize(key, dataValue, metadataSize);
    }

    @Override
    public boolean isEqual(long address, TieredStoreRecord value) {
        return this.recordAccessor.isEqual(address, value);
    }

    @Override
    public boolean isEqual(long address1, long address2) {
        return this.recordAccessor.isEqual(address1, address2);
    }

    @Override
    public TieredStoreRecord read(long address) {
        return this.recordAccessor.read(address);
    }

    @Override
    public long dispose(long address) {
        long size = this.recordAccessor.dispose(address);
        return size;
    }

    @Override
    public long dispose(TieredStoreRecord block) {
        long size = this.recordAccessor.dispose(block);
        return size;
    }

    @Override
    public TieredStoreRecord newRecord() {
        return this.recordAccessor.newRecord();
    }

    @Override
    public NativeMemoryData readData(long valueAddress) {
        return this.recordAccessor.readData(valueAddress);
    }

    @Override
    public Object readValue(TieredStoreRecord record) {
        return this.recordAccessor.readValue(record);
    }

    @Override
    public long readValueAddress(TieredStoreRecord record) {
        return this.recordAccessor.readValueAddress(record);
    }

    @Override
    public void setValueAddress(TieredStoreRecord record, long address) {
        this.recordAccessor.setValueAddress(record, address);
    }

    @Override
    public void setValue(TieredStoreRecord record, Data value) {
        this.recordAccessor.setValue(record, value);
    }

    @Override
    public long disposeValue(TieredStoreRecord record) {
        long size = this.recordAccessor.disposeValue(record);
        return size;
    }

    @Override
    public long disposeData(NativeMemoryData data) {
        long size = this.recordAccessor.disposeData(data);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    @Override
    public long disposeData(long address) {
        long size = this.recordAccessor.disposeData(address);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    @Override
    public Data toData(Object obj, DataType dataType) {
        Object data = dataType == DataType.NATIVE ? this.serializationService.toNativeData(obj, this.serializationService.getMemoryManager()) : this.serializationService.toData(obj, dataType);
        if (data instanceof NativeMemoryData && data != obj) {
            this.storageInfo.addUsedMemory(this.recordAccessor.getSize((NativeMemoryData)data));
        }
        return data;
    }

    @Override
    public Object toObject(Object data) {
        return this.serializationService.toObject(data, this.serializationService.getMemoryManager());
    }

    @Override
    public Data convertData(Data data, DataType dataType) {
        Object convertedData = dataType == DataType.NATIVE ? this.serializationService.convertToNativeData(data, this.serializationService.getMemoryManager()) : this.serializationService.convertData(data, dataType);
        if (convertedData instanceof NativeMemoryData && convertedData != data) {
            this.storageInfo.addUsedMemory(this.recordAccessor.getSize((NativeMemoryData)convertedData));
        }
        return convertedData;
    }

    @Override
    public void disposeData(Data data) {
        throw new UnsupportedOperationException("Dispose is not supported for the hybrid log");
    }

    @Override
    public long allocate(long size) {
        HybridLog hybridLog = this.recordAccessor.getHybridLog();
        long logicalAddress = hybridLog.allocate(size);
        this.storageInfo.addUsedMemory(size);
        return hybridLog.asPhysicalAddress(logicalAddress);
    }

    @Override
    public void free(long address, long size) {
        throw new UnsupportedOperationException("Free is not supported for the hybrid log");
    }

    @Override
    public void addDeferredDispose(MemoryBlock memoryBlock) {
        throw new UnsupportedOperationException("Tiered store record is disposed on compaction");
    }

    @Override
    public void disposeDeferredBlocks() {
        throw new UnsupportedOperationException("Tiered store record is disposed on compaction");
    }

    @Override
    public long getSize(MemoryBlock memoryBlock) {
        return this.recordAccessor.getSize(memoryBlock);
    }

    @Override
    public long getSize(long address, long expectedSize) {
        return this.recordAccessor.getSize(address, expectedSize);
    }

    @Override
    public MemoryAllocator unwrapMemoryAllocator() {
        throw new UnsupportedOperationException("Hybrid log has no wrapped memory allocator");
    }

    @Override
    public long getUsedMemory() {
        return this.storageInfo.getUsedMemory();
    }

    @Override
    public long increaseUsedMemory(long size) {
        return this.storageInfo.addUsedMemory(size);
    }

    @Override
    public long decreaseUsedMemory(long size) {
        return this.storageInfo.removeUsedMemory(size);
    }

    public boolean isInMemory(TieredStoreRecord record) {
        return this.recordAccessor.isInMemory(record);
    }

    public boolean isMutable(long logicalRecord) {
        return this.getHybridLog().isMutable(logicalRecord);
    }

    public HybridLog getHybridLog() {
        return this.recordAccessor.getHybridLog();
    }

    public TieredStoreRecordAccessor getRecordAccessor() {
        return this.recordAccessor;
    }
}

