/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.tree.impl;

import com.hazelcast.internal.elastic.tree.OffHeapTreeEntry;
import com.hazelcast.internal.elastic.tree.OrderingDirection;
import com.hazelcast.internal.elastic.tree.impl.RedBlackTreeNode;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EntryIterator
implements Iterator<OffHeapTreeEntry> {
    private RedBlackTreeNode currNode;
    private OrderingDirection direction;

    EntryIterator(RedBlackTreeNode root, OrderingDirection direction) {
        this.direction = direction;
        this.currNode = root != null ? this.first(root) : null;
    }

    @Override
    public boolean hasNext() {
        return this.currNode != null && !this.currNode.isNil();
    }

    @Override
    public OffHeapTreeEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        OffHeapTreeEntry result = this.currNode.entry();
        this.currNode = this.next(this.currNode);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean checkSide(byte side, OrderingDirection direction) {
        return side == 1 && direction == OrderingDirection.ASC || side == 0 && direction == OrderingDirection.DESC;
    }

    private RedBlackTreeNode next(RedBlackTreeNode node) {
        RedBlackTreeNode parent;
        RedBlackTreeNode child;
        RedBlackTreeNode redBlackTreeNode = child = this.direction == OrderingDirection.ASC ? node.right() : node.left();
        if (!child.isNil()) {
            return this.first(child);
        }
        byte side = node.side();
        if (this.checkSide(side, this.direction) && (parent = node.parent()) != null) {
            return parent;
        }
        while (!this.checkSide(side, this.direction)) {
            parent = node.parent();
            if (parent == null) {
                return null;
            }
            node = parent;
            side = node.side();
        }
        return node.parent();
    }

    private RedBlackTreeNode first(RedBlackTreeNode node) {
        if (node.isNil()) {
            return null;
        }
        RedBlackTreeNode current = node;
        RedBlackTreeNode next;
        while (!(next = this.direction == OrderingDirection.ASC ? current.left() : current.right()).isNil()) {
            current = next;
        }
        return current;
    }
}

