/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.queue;

import com.hazelcast.internal.elastic.LongIterator;
import com.hazelcast.internal.elastic.queue.BlockingElasticQueue;
import com.hazelcast.internal.elastic.queue.LongBlockingQueue;
import com.hazelcast.internal.elastic.queue.LongConsumer;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

abstract class AbstractBlockingElasticQueue<E>
extends AbstractQueue<E>
implements BlockingElasticQueue<E> {
    private final LongBlockingQueue queue;
    private final EnterpriseSerializationService ss;

    protected AbstractBlockingElasticQueue(EnterpriseSerializationService ss, int capacity, MemoryAllocator malloc) {
        this.ss = ss;
        this.queue = this.createQueue(malloc, capacity, 0L);
    }

    protected abstract LongBlockingQueue createQueue(MemoryAllocator var1, int var2, long var3);

    @Override
    public final boolean offer(E e) {
        NativeMemoryData binary = (NativeMemoryData)this.ss.toData(e, DataType.NATIVE);
        if (this.queue.offer(binary.address())) {
            return true;
        }
        this.ss.disposeData(binary);
        return false;
    }

    @Override
    public final E poll() {
        return this.first(true);
    }

    @Override
    public final E peek() {
        return this.first(false);
    }

    private E first(boolean remove) {
        long address = this.queue.poll();
        return this.toItem(address, remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E toItem(long address, boolean dispose) {
        if (address != this.queue.nullItem()) {
            NativeMemoryData data = new NativeMemoryData().reset(address);
            try {
                Object t = this.ss.toObject(data);
                return (E)t;
            }
            finally {
                if (dispose) {
                    this.ss.disposeData(data);
                }
            }
        }
        return null;
    }

    @Override
    public final void put(E e) throws InterruptedException {
        NativeMemoryData binary = (NativeMemoryData)this.ss.toData(e, DataType.NATIVE);
        this.queue.put(binary.address());
    }

    @Override
    public final boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        NativeMemoryData binary = (NativeMemoryData)this.ss.toData(e, DataType.NATIVE);
        if (this.queue.offer(binary.address(), timeout, unit)) {
            return true;
        }
        this.ss.disposeData(binary);
        return false;
    }

    @Override
    public final E take() throws InterruptedException {
        long address = this.queue.take();
        return this.toItem(address, true);
    }

    @Override
    public final E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long address = this.queue.poll(timeout, unit);
        return this.toItem(address, true);
    }

    @Override
    public final int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    @Override
    public final void clear() {
        this.queue.clear();
    }

    @Override
    public final int size() {
        return this.queue.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public final void destroy() {
        this.queue.dispose();
    }

    @Override
    public final int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public final int drainTo(Collection<? super E> c, int maxElements) {
        ConsumerImpl consumer = new ConsumerImpl(c, maxElements);
        this.queue.consume(consumer);
        return maxElements - consumer.count;
    }

    @Override
    public final Iterator<E> iterator() {
        return new ItemIterator();
    }

    private class ItemIterator
    implements Iterator<E> {
        final LongIterator iter;

        private ItemIterator() {
            this.iter = AbstractBlockingElasticQueue.this.queue.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            long address = this.iter.next();
            return AbstractBlockingElasticQueue.this.toItem(address, false);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ConsumerImpl
    implements LongConsumer {
        final Collection<? super E> coll;
        int count;

        ConsumerImpl(Collection<? super E> coll, int count) {
            this.coll = coll;
            this.count = count;
        }

        @Override
        public boolean consume(long value) {
            if (this.count > 0) {
                NativeMemoryData data = new NativeMemoryData().reset(value);
                Object item = AbstractBlockingElasticQueue.this.ss.toObject(data);
                if (this.coll.add(item)) {
                    AbstractBlockingElasticQueue.this.ss.disposeData(data);
                    --this.count;
                    return true;
                }
            }
            return false;
        }
    }
}

