/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.map;

import com.hazelcast.internal.elastic.map.BehmSlotAccessor;
import com.hazelcast.internal.elastic.map.BinaryElasticHashMap;
import com.hazelcast.internal.elastic.map.NativeBehmSlotAccessorFactory;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.memory.MemoryBlockAccessor;
import com.hazelcast.internal.memory.MemoryBlockProcessor;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.internal.util.ThreadLocalRandomProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class SampleableElasticHashMap<V extends MemoryBlock>
extends BinaryElasticHashMap<V> {
    public SampleableElasticHashMap(int initialCapacity, EnterpriseSerializationService serializationService, MemoryBlockAccessor<V> memoryBlockAccessor, MemoryAllocator malloc) {
        super(initialCapacity, serializationService, new NativeBehmSlotAccessorFactory(), memoryBlockAccessor, malloc);
    }

    public SampleableElasticHashMap(int initialCapacity, float loadFactor, EnterpriseSerializationService serializationService, MemoryBlockAccessor<V> memoryBlockAccessor, MemoryAllocator malloc) {
        super(initialCapacity, loadFactor, serializationService, new NativeBehmSlotAccessorFactory(), memoryBlockAccessor, malloc);
    }

    public SampleableElasticHashMap(int initialCapacity, MemoryBlockProcessor<V> memoryBlockProcessor) {
        super(initialCapacity, new NativeBehmSlotAccessorFactory(), memoryBlockProcessor);
    }

    public SampleableElasticHashMap(int initialCapacity, float loadFactor, MemoryBlockProcessor<V> memoryBlockProcessor) {
        super(initialCapacity, loadFactor, new NativeBehmSlotAccessorFactory(), memoryBlockProcessor);
    }

    protected <E extends SamplingEntry> E createSamplingEntry(int slot) {
        return (E)new SamplingEntry(slot);
    }

    public <E extends SamplingEntry> Iterable<E> getRandomSamples(int sampleCount) {
        if (sampleCount < 0) {
            throw new IllegalArgumentException("Sample count cannot be a negative value.");
        }
        if (sampleCount == 0 || this.size() == 0) {
            return Collections.emptyList();
        }
        return new LazySamplingEntryIterableIterator(sampleCount);
    }

    private boolean isValidForSampling(int slot) {
        return this.accessor.isAssigned(slot);
    }

    protected boolean hasNotBeenObserved(int keyHash, IterationPointer[] pointers) {
        if (pointers.length < 2) {
            return true;
        }
        for (int i = 0; i < pointers.length - 1; ++i) {
            IterationPointer iterationPointer = pointers[i];
            int tableCapacity = iterationPointer.getSize();
            int mask = tableCapacity - 1;
            int seenBaseSlot = iterationPointer.getIndex();
            int keySlot = BehmSlotAccessor.rehash(keyHash, HashUtil.computePerturbationValue(tableCapacity));
            int keyBaseSlot = keySlot & mask;
            if (keyBaseSlot >= seenBaseSlot) continue;
            return false;
        }
        return true;
    }

    private final class LazySamplingEntryIterableIterator<E extends SamplingEntry>
    implements Iterable<E>,
    Iterator<E> {
        private static final int NOT_INITIALIZED = Integer.MIN_VALUE;
        private final int maxSampleCount;
        private final int end;
        private final int segmentCount;
        private final int segmentSize;
        private final int randomSegment;
        private final int randomIndex;
        private int currentSegmentNo;
        private boolean toRight;
        private int passedSegmentCount;
        private int returnedEntryCount;
        private int currentIndex;
        private boolean reachedToEnd;
        private E currentSample;

        private LazySamplingEntryIterableIterator(int maxSampleCount) {
            this.maxSampleCount = maxSampleCount;
            this.end = SampleableElasticHashMap.this.capacity();
            assert (QuickMath.isPowerOfTwo(this.end));
            this.segmentCount = Math.min(QuickMath.nextPowerOfTwo(maxSampleCount * 2), this.end);
            this.segmentSize = this.end / this.segmentCount;
            Random random = ThreadLocalRandomProvider.get();
            this.randomSegment = random.nextInt(this.segmentCount);
            this.randomIndex = random.nextInt(this.segmentSize);
            this.currentSegmentNo = this.randomSegment;
            this.passedSegmentCount = 0;
            this.toRight = true;
            this.currentIndex = Integer.MIN_VALUE;
        }

        @Override
        public Iterator<E> iterator() {
            return this;
        }

        private void iterate() {
            int segmentStart;
            if (this.returnedEntryCount >= this.maxSampleCount || this.reachedToEnd) {
                this.currentSample = null;
                return;
            }
            if (this.toRight) {
                while (this.passedSegmentCount < this.segmentCount) {
                    int ix;
                    segmentStart = this.currentSegmentNo * this.segmentSize;
                    int segmentEnd = segmentStart + this.segmentSize;
                    int n = ix = this.currentIndex == Integer.MIN_VALUE ? segmentStart + this.randomIndex : this.currentIndex + 1;
                    while (ix < segmentEnd && !SampleableElasticHashMap.this.isValidForSampling(ix)) {
                        ++ix;
                    }
                    if (ix < segmentEnd) {
                        this.currentSample = SampleableElasticHashMap.this.createSamplingEntry(ix);
                        this.currentIndex = ix;
                        ++this.returnedEntryCount;
                        return;
                    }
                    this.nextSegment();
                }
                this.currentSegmentNo = this.randomSegment;
                this.passedSegmentCount = 0;
                this.currentIndex = Integer.MIN_VALUE;
                this.toRight = false;
            }
            while (this.passedSegmentCount < this.segmentCount) {
                int ix;
                segmentStart = this.currentSegmentNo * this.segmentSize;
                int n = ix = this.currentIndex == Integer.MIN_VALUE ? segmentStart + this.randomIndex - 1 : this.currentIndex - 1;
                while (ix >= segmentStart && !SampleableElasticHashMap.this.isValidForSampling(ix)) {
                    --ix;
                }
                if (ix >= segmentStart) {
                    this.currentSample = SampleableElasticHashMap.this.createSamplingEntry(ix);
                    this.currentIndex = ix;
                    ++this.returnedEntryCount;
                    return;
                }
                this.nextSegment();
            }
            this.reachedToEnd = true;
            this.currentSample = null;
        }

        @Override
        public boolean hasNext() {
            if (this.currentSample == null) {
                this.iterate();
            }
            return this.currentSample != null;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                E returnedItem = this.currentSample;
                this.currentSample = null;
                return returnedItem;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing is not supported");
        }

        private void nextSegment() {
            ++this.passedSegmentCount;
            this.currentSegmentNo = (this.currentSegmentNo + 1) % this.segmentCount;
            this.currentIndex = Integer.MIN_VALUE;
        }
    }

    @SuppressFBWarnings(value={"PZ_DONT_REUSE_ENTRY_OBJECTS_IN_ITERATORS"})
    public class IterableSamplingEntry
    extends SamplingEntry
    implements Iterable<IterableSamplingEntry>,
    Iterator<IterableSamplingEntry> {
        private boolean iterated;

        public IterableSamplingEntry(int slot) {
            super(slot);
        }

        @Override
        public Iterator<IterableSamplingEntry> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return !this.iterated;
        }

        @Override
        public IterableSamplingEntry next() {
            if (this.iterated) {
                throw new NoSuchElementException();
            }
            this.iterated = true;
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing is supported");
        }
    }

    public class SamplingEntry {
        private final int slot;

        protected SamplingEntry(int slot) {
            this.slot = slot;
        }

        public NativeMemoryData getEntryKey() {
            return SampleableElasticHashMap.this.accessor.keyData(this.slot);
        }

        public V getEntryValue() {
            long value = SampleableElasticHashMap.this.accessor.getValue(this.slot);
            return SampleableElasticHashMap.this.readV(value);
        }
    }
}

