/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.rewrite;

import com.hazelcast.internal.dynamicconfig.rewrite.RewritePath;
import com.hazelcast.internal.dynamicconfig.rewrite.RewritePositionFinder;
import com.hazelcast.org.snakeyaml.engine.v2.api.Load;
import com.hazelcast.org.snakeyaml.engine.v2.api.LoadSettings;
import com.hazelcast.org.snakeyaml.engine.v2.common.FlowStyle;
import com.hazelcast.org.snakeyaml.engine.v2.composer.Composer;
import com.hazelcast.org.snakeyaml.engine.v2.constructor.BaseConstructor;
import com.hazelcast.org.snakeyaml.engine.v2.constructor.StandardConstructor;
import com.hazelcast.org.snakeyaml.engine.v2.nodes.MappingNode;
import com.hazelcast.org.snakeyaml.engine.v2.nodes.Node;
import com.hazelcast.org.snakeyaml.engine.v2.nodes.NodeTuple;
import com.hazelcast.org.snakeyaml.engine.v2.nodes.NodeType;
import com.hazelcast.org.snakeyaml.engine.v2.nodes.ScalarNode;
import com.hazelcast.org.snakeyaml.engine.v2.nodes.SequenceNode;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

class RewritePositionFinderYaml
extends RewritePositionFinder {
    int flowCount;

    RewritePositionFinderYaml(String yamlDocumentAsString, RewritePath targetPath) {
        super(yamlDocumentAsString, targetPath);
    }

    @Override
    void setPositions() {
        this.findPositionAndLoadYamlDocument();
        this.updateEndPositionAccordingToFlowCount();
    }

    private void findPositionAndLoadYamlDocument() {
        LoadSettings loadSettings = LoadSettings.builder().setUseMarks(true).build();
        FindPositionAndLoad findPositionAndLoad = new FindPositionAndLoad(loadSettings, this.targetPath);
        findPositionAndLoad.loadFromReader(new StringReader(this.documentAsString));
    }

    private void updateEndPositionAccordingToFlowCount() {
        while (this.flowCount > 0) {
            if (this.documentAsString.charAt(this.endPosition) == '}' || this.documentAsString.charAt(this.endPosition) == ']') {
                --this.flowCount;
            }
            ++this.endPosition;
        }
    }

    private final class FindPositionAndLoad
    extends Load {
        private final BaseConstructor constructor;
        private final RewritePath targetPathCopy;

        private FindPositionAndLoad(LoadSettings settings, RewritePath targetPath) {
            this(settings, new StandardConstructor(settings), targetPath);
        }

        private FindPositionAndLoad(LoadSettings settings, BaseConstructor constructor, RewritePath targetPath) {
            super(settings, constructor);
            this.targetPathCopy = new RewritePath(targetPath);
            this.constructor = constructor;
        }

        @Override
        protected Object loadOne(Composer composer) {
            Optional<Node> nodeOptional = composer.getSingleNode();
            nodeOptional.ifPresent(this::traverse);
            if (RewritePositionFinderYaml.this.differencePath == null) {
                this.targetPathCopy.removeLastSegment();
                RewritePositionFinderYaml.this.differencePath = this.targetPathCopy;
                RewritePath.checkPathOnlyContainsTypeSegments(RewritePositionFinderYaml.this.differencePath);
                RewritePositionFinderYaml.this.shouldTrim = true;
            }
            return this.constructor.constructSingleDocument(nodeOptional);
        }

        private void traverse(Node node) {
            LinkedList<Node> nodeQueue = new LinkedList<Node>();
            nodeQueue.add(node);
            Node previousKeyNode = null;
            Node keyNode = null;
            boolean pathFound = false;
            block0: while (!nodeQueue.isEmpty()) {
                node = (Node)nodeQueue.poll();
                MappingNode mappingNode = (MappingNode)node;
                for (NodeTuple nodeTuple : mappingNode.getValue()) {
                    keyNode = (ScalarNode)nodeTuple.getKeyNode();
                    node = nodeTuple.getValueNode();
                    String segmentWithoutSeparator = ((ScalarNode)keyNode).getValue();
                    if (!this.targetPathCopy.removeFirstIfSegmentMatches(segmentWithoutSeparator)) continue;
                    if (this.targetPathCopy.segmentCount() == 0) {
                        pathFound = true;
                        continue block0;
                    }
                    if (node.getNodeType() != NodeType.MAPPING) continue;
                    previousKeyNode = keyNode;
                    nodeQueue.add(node);
                }
            }
            if (pathFound) {
                RewritePositionFinderYaml.this.startPosition = keyNode.getStartMark().get().getIndex();
                RewritePositionFinderYaml.this.endPosition = this.findEndPosition(node);
                RewritePositionFinderYaml.this.shouldTrim = true;
            } else {
                this.targetPathCopy.removeLastSegment();
                assert (previousKeyNode != null);
                RewritePositionFinderYaml.this.endPosition = RewritePositionFinderYaml.this.startPosition = previousKeyNode.getEndMark().get().getIndex() + 1;
            }
            RewritePositionFinderYaml.this.differencePath = this.targetPathCopy;
            RewritePath.checkPathOnlyContainsTypeSegments(RewritePositionFinderYaml.this.differencePath);
        }

        private int findEndPosition(Node node) {
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                if (mappingNode.getFlowStyle() == FlowStyle.FLOW) {
                    ++RewritePositionFinderYaml.this.flowCount;
                }
                List<NodeTuple> nodeTupleList = mappingNode.getValue();
                Node lastValueNode = nodeTupleList.get(nodeTupleList.size() - 1).getValueNode();
                return this.findEndPosition(lastValueNode);
            }
            if (node instanceof SequenceNode) {
                SequenceNode sequenceNodeNode = (SequenceNode)node;
                if (sequenceNodeNode.getFlowStyle() == FlowStyle.FLOW) {
                    ++RewritePositionFinderYaml.this.flowCount;
                }
                List<Node> nodeTupleList = sequenceNodeNode.getValue();
                Node lastValueNode = nodeTupleList.get(nodeTupleList.size() - 1);
                return this.findEndPosition(lastValueNode);
            }
            return node.getEndMark().get().getIndex();
        }
    }
}

