/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.rewrite;

import com.hazelcast.config.Config;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteUtil;
import com.hazelcast.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;

public final class RewriteBackup {
    private static final String BACKUP_SUFFIX = ".backup";

    private RewriteBackup() {
    }

    public static void takeBackup(Config config, ILogger logger) throws IOException {
        int maxBackupCount = config.getDynamicConfigurationConfig().getBackupCount();
        if (maxBackupCount <= 0) {
            return;
        }
        File configurationFile = RewriteUtil.getDynamicConfigurationPersistenceFile(config);
        File backupDir = config.getDynamicConfigurationConfig().getBackupDir();
        if (!backupDir.exists() && !backupDir.mkdirs()) {
            throw new IOException("Can't create the backup directory for dynamic configuration.");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd--HH-mm-ss-SSS");
        try {
            Files.copy(configurationFile.toPath(), new File(backupDir, LocalDateTime.now().format(formatter) + BACKUP_SUFFIX).toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new IOException("Can't take a backup.", e);
        }
        if (RewriteBackup.findNumberOfExistingBackupFiles(backupDir) > maxBackupCount && !Objects.requireNonNull(RewriteBackup.findOldestBackup(backupDir)).delete()) {
            throw new IOException("Can't delete the oldest backup file for dynamic configuration.");
        }
    }

    static File[] sortBackups(File[] backups) {
        Arrays.sort(backups);
        return backups;
    }

    private static File findOldestBackup(File backupDir) {
        File[] sortedFiles = RewriteBackup.sortBackups(backupDir.listFiles());
        for (File file : Objects.requireNonNull(sortedFiles)) {
            if (!file.getName().endsWith(BACKUP_SUFFIX)) continue;
            return file;
        }
        return null;
    }

    private static int findNumberOfExistingBackupFiles(File backupDir) {
        int currentBackupCount = 0;
        for (File file : Objects.requireNonNull(backupDir.listFiles())) {
            if (!file.getName().endsWith(BACKUP_SUFFIX)) continue;
            ++currentBackupCount;
        }
        return currentBackupCount;
    }
}

