/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.sync;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.enterprise.wan.impl.AbstractWanAntiEntropyEvent;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.sync.SyncFailedException;
import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventPublishOperation;
import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventResult;
import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventStarterOperation;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.monitor.WanSyncState;
import com.hazelcast.internal.monitor.impl.WanSyncStateImpl;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.util.collection.InflatableSet;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.wan.impl.WanSyncStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class WanSyncManager {
    private static final int RETRY_INTERVAL_MILLIS = 5000;
    private static final int MAX_RETRY_COUNT = 5;
    private static final AtomicReferenceFieldUpdater<WanSyncManager, WanSyncStatus> SYNC_STATUS = AtomicReferenceFieldUpdater.newUpdater(WanSyncManager.class, WanSyncStatus.class, "syncStatus");
    private final EnterpriseWanReplicationService wanReplicationService;
    private final ILogger logger;
    private final Node node;
    private volatile WanSyncStatus syncStatus = WanSyncStatus.READY;
    private volatile boolean running = true;
    private volatile String activeWanReplicationName;
    private volatile String activePublisherId;

    public WanSyncManager(EnterpriseWanReplicationService wanReplicationService, Node node) {
        this.node = node;
        this.wanReplicationService = wanReplicationService;
        this.logger = node.getLogger(this.getClass());
    }

    public void shutdown() {
        this.running = false;
    }

    public void initiateAntiEntropyRequest(String wanReplicationName, String wanPublisherId, AbstractWanAntiEntropyEvent event) {
        if (this.wanReplicationService.getPublisherOrNull(wanReplicationName, wanPublisherId) == null) {
            String errorMsg = String.format("Sync request failed because WAN Replication Config doesn't exist with WAN configuration name %s and publisher ID %s.", wanReplicationName, wanPublisherId);
            if (this.node.isLiteMember()) {
                errorMsg = errorMsg + " If you have added the WAN configuration dynamically, try re-running WAN sync on non-lite members.";
            }
            throw new InvalidConfigurationException(errorMsg);
        }
        if (!SYNC_STATUS.compareAndSet(this, WanSyncStatus.READY, WanSyncStatus.IN_PROGRESS)) {
            throw new SyncFailedException("Another anti-entropy request is already in progress.");
        }
        this.activeWanReplicationName = wanReplicationName;
        this.activePublisherId = wanPublisherId;
        this.node.getNodeEngine().getExecutionService().execute("hz:wan:sync:pool", () -> {
            WanAntiEntropyEventStarterOperation op = new WanAntiEntropyEventStarterOperation(wanReplicationName, wanPublisherId, event);
            InvocationFuture future = this.getOperationService().invokeOnTarget("hz:core:wanReplicationService", op, this.node.getThisAddress());
            ((InternalCompletableFuture)future).whenCompleteAsync((response, t) -> {
                if (t == null) {
                    this.logger.info("WAN anti-entropy request " + event + " has been processed");
                } else {
                    this.logger.warning("WAN anti-entropy request " + event + " processing failed", (Throwable)t);
                }
            });
        });
        this.logger.info("WAN anti-entropy request " + event + " has been sent");
    }

    public WanSyncState getWanSyncState() {
        return new WanSyncStateImpl(this.syncStatus, this.activeWanReplicationName, this.activePublisherId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishAntiEntropyEventOnMembers(String wanReplicationName, String wanPublisherId, AbstractWanAntiEntropyEvent event) {
        int retryCount = 0;
        try {
            Set<Integer> partitionsToSync = event.getPartitionSet();
            while (this.running) {
                this.broadcastEvent(wanReplicationName, wanPublisherId, event, partitionsToSync);
                if (partitionsToSync.isEmpty()) break;
                if (++retryCount == 5) {
                    this.logger.warning(String.format("WAN anti-entropy event publication failed after %s attempts with %s partitions not processed", 5, partitionsToSync.size()));
                    break;
                }
                this.logger.info(String.format("WAN anti-entropy event publication will retry because %s partitions have not been processed", partitionsToSync.size()));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
            SYNC_STATUS.set(this, retryCount == 5 ? WanSyncStatus.FAILED : WanSyncStatus.READY);
        }
        catch (Throwable throwable) {
            SYNC_STATUS.set(this, retryCount == 5 ? WanSyncStatus.FAILED : WanSyncStatus.READY);
            throw throwable;
        }
    }

    private void broadcastEvent(String wanReplicationName, String wanPublisherId, AbstractWanAntiEntropyEvent event, Set<Integer> partitionsToSync) {
        Collection<Member> members = this.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        ArrayList<Future<WanAntiEntropyEventResult>> futures = new ArrayList<Future<WanAntiEntropyEventResult>>(members.size());
        for (Member member : members) {
            AbstractWanAntiEntropyEvent clonedEvent = event.cloneWithoutPartitionKeys();
            clonedEvent.setPartitionSet(partitionsToSync);
            WanAntiEntropyEventPublishOperation operation = new WanAntiEntropyEventPublishOperation(wanReplicationName, wanPublisherId, clonedEvent);
            InvocationFuture future = this.getOperationService().invokeOnTarget("hz:core:wanReplicationService", operation, member.getAddress());
            futures.add(future);
        }
        if (partitionsToSync == null || partitionsToSync.isEmpty()) {
            partitionsToSync = this.getAllPartitions();
        }
        this.addResultOfOps(futures, partitionsToSync);
    }

    private OperationService getOperationService() {
        return this.node.getNodeEngine().getOperationService();
    }

    private void addResultOfOps(List<Future<WanAntiEntropyEventResult>> futures, Set<Integer> partitionsToSync) {
        boolean alreadyLogged = false;
        for (Future<WanAntiEntropyEventResult> future : futures) {
            try {
                WanAntiEntropyEventResult result = future.get();
                partitionsToSync.removeAll(result.getProcessedPartitions());
            }
            catch (Exception ex) {
                if (alreadyLogged) continue;
                this.logger.warning("Exception occurred during WAN sync, missing WAN sync objects will be retried.", ex);
                alreadyLogged = true;
            }
        }
    }

    private Set<Integer> getAllPartitions() {
        int partitionCount = this.getPartitionService().getPartitionCount();
        InflatableSet.Builder builder = InflatableSet.newBuilder(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            builder.add((Object)i);
        }
        return builder.build();
    }

    private IPartitionService getPartitionService() {
        return this.node.getPartitionService();
    }

    private ClusterService getClusterService() {
        return this.node.getClusterService();
    }

    public void setActiveWanReplicationName(String activeWanReplicationName) {
        this.activeWanReplicationName = activeWanReplicationName;
    }

    public void setActivePublisherId(String activePublisherId) {
        this.activePublisherId = activePublisherId;
    }
}

