/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication.compact;

import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.connection.WanConnectionWrapper;
import com.hazelcast.enterprise.wan.impl.operation.WanProtocolNegotiationResponse;
import com.hazelcast.enterprise.wan.impl.replication.WanEventBatch;
import com.hazelcast.enterprise.wan.impl.replication.compact.SchemaReplicationTracker;
import com.hazelcast.internal.serialization.impl.compact.schema.MemberSchemaService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class WanCompactSchemaReplicationManager {
    public static final String CLUSTER_ID_METADATA_KEY = "clusterId";
    private static final Function<String, SchemaReplicationTracker> TRACKER_CONSTRUCTOR_FUNCTION = key -> new SchemaReplicationTracker();
    private final ConcurrentHashMap<String, SchemaReplicationTracker> trackers = new ConcurrentHashMap();
    private final MemberSchemaService schemaService;

    public WanCompactSchemaReplicationManager(MemberSchemaService schemaService) {
        this.schemaService = schemaService;
    }

    public void addNotYetReplicatedSchemasToEvent(WanEventBatch eventBatch, WanProtocolNegotiationResponse response) {
        if (response.getChosenWanProtocolVersion().isLessThan(EnterpriseWanReplicationService.COMPACT_SUPPORTED_WAN_PROTOCOL_VERSION)) {
            return;
        }
        Map<String, String> metadata = response.getMetadata();
        if (metadata == null) {
            return;
        }
        String clusterId = metadata.get(CLUSTER_ID_METADATA_KEY);
        if (clusterId == null) {
            return;
        }
        SchemaReplicationTracker tracker = this.trackers.computeIfAbsent(clusterId, TRACKER_CONSTRUCTOR_FUNCTION);
        tracker.addNotYetReplicatedSchemasToEvent(eventBatch, this.schemaService);
    }

    public void onSchemaReplicationAcknowledgment(String clusterId, List<Long> schemaIds) {
        SchemaReplicationTracker tracker = this.trackers.get(clusterId);
        if (tracker == null) {
            return;
        }
        tracker.onReplicatedSchemaAcknowledgment(schemaIds);
    }

    public void onConnectionClose(WanConnectionWrapper connectionWrapper) {
        if (connectionWrapper == null) {
            return;
        }
        WanProtocolNegotiationResponse response = connectionWrapper.getNegotiationResponse();
        if (response == null) {
            return;
        }
        Map<String, String> metadata = response.getMetadata();
        if (metadata == null) {
            return;
        }
        String clusterId = metadata.get(CLUSTER_ID_METADATA_KEY);
        if (clusterId == null) {
            return;
        }
        this.trackers.remove(clusterId);
    }
}

