/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.cluster.Address;
import com.hazelcast.enterprise.wan.impl.WanConsistencyCheckEvent;
import com.hazelcast.enterprise.wan.impl.WanSyncEvent;
import com.hazelcast.enterprise.wan.impl.connection.WanConnectionWrapper;
import com.hazelcast.enterprise.wan.impl.operation.MerkleTreeNodeValueComparison;
import com.hazelcast.enterprise.wan.impl.operation.WanMerkleTreeNodeCompareOperation;
import com.hazelcast.enterprise.wan.impl.replication.MerkleTreeComparisonProcessor;
import com.hazelcast.enterprise.wan.impl.replication.WanBatchPublisher;
import com.hazelcast.enterprise.wan.impl.replication.WanConfigurationContext;
import com.hazelcast.enterprise.wan.impl.replication.WanMerkleTreeSyncStats;
import com.hazelcast.enterprise.wan.impl.replication.WanPublisherSyncSupport;
import com.hazelcast.enterprise.wan.impl.replication.WanSyncContext;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.management.events.WanConsistencyCheckFinishedEvent;
import com.hazelcast.internal.management.events.WanConsistencyCheckIgnoredEvent;
import com.hazelcast.internal.management.events.WanConsistencyCheckStartedEvent;
import com.hazelcast.internal.management.events.WanMerkleSyncFinishedEvent;
import com.hazelcast.internal.management.events.WanSyncIgnoredEvent;
import com.hazelcast.internal.management.events.WanSyncProgressUpdateEvent;
import com.hazelcast.internal.management.events.WanSyncStartedEvent;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MerkleTreeNodeEntries;
import com.hazelcast.map.impl.operation.MerkleTreeGetEntriesOperation;
import com.hazelcast.map.impl.operation.MerkleTreeGetEntryCountOperation;
import com.hazelcast.map.impl.operation.MerkleTreeNodeCompareOperationFactory;
import com.hazelcast.map.impl.wan.WanEnterpriseMapEvent;
import com.hazelcast.map.impl.wan.WanEnterpriseMapMerkleTreeNode;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.wan.impl.ConsistencyCheckResult;
import com.hazelcast.wan.impl.WanAntiEntropyEvent;
import com.hazelcast.wan.impl.WanSyncStats;
import com.hazelcast.wan.impl.WanSyncType;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WanPublisherMerkleTreeSyncSupport
implements WanPublisherSyncSupport {
    private static final HazelcastProperty SYNC_ALL_MAPS_LEGACY = new HazelcastProperty("hazelcast.wan.sync.allmaps.legacy", false);
    private static final int WAN_TARGET_INVOCATION_DEADLINE_SECONDS = 10;
    private static final int WAN_TARGET_INVOCATION_MIN_ATTEMPTS = 10;
    private static final long WAN_TARGET_INVOCATION_BACKOFF_MIN_PARK = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final long WAN_TARGET_INVOCATION_BACKOFF_MAX_PARK = TimeUnit.MILLISECONDS.toNanos(100L);
    private final NodeEngineImpl nodeEngine;
    private final MapService mapService;
    private final WanConfigurationContext configurationContext;
    private final ILogger logger;
    private final Map<String, ConsistencyCheckResult> lastConsistencyCheckResults = new ConcurrentHashMap<String, ConsistencyCheckResult>();
    private final Map<String, WanSyncStats> lastSyncStats = new ConcurrentHashMap<String, WanSyncStats>();
    private final WanBatchPublisher publisher;
    private final Map<UUID, WanSyncContext<WanMerkleTreeSyncStats>> syncContextMap = new ConcurrentHashMap<UUID, WanSyncContext<WanMerkleTreeSyncStats>>();
    private final IdleStrategy wanTargetInvocationIdleStrategy;
    private final ExecutorService updateSerializingExecutor;

    WanPublisherMerkleTreeSyncSupport(Node node, WanConfigurationContext configurationContext, WanBatchPublisher publisher) {
        this.nodeEngine = Preconditions.checkNotNull(node.getNodeEngine());
        this.mapService = (MapService)this.nodeEngine.getService("hz:impl:mapService");
        this.logger = Preconditions.checkNotNull(node.getLogger(this.getClass()));
        this.configurationContext = Preconditions.checkNotNull(configurationContext);
        this.publisher = Preconditions.checkNotNull(publisher);
        this.wanTargetInvocationIdleStrategy = new BackoffIdleStrategy(0L, 0L, WAN_TARGET_INVOCATION_BACKOFF_MIN_PARK, WAN_TARGET_INVOCATION_BACKOFF_MAX_PARK);
        this.updateSerializingExecutor = Executors.newSingleThreadExecutor(r -> new Thread(r, ThreadUtil.createThreadName(node.hazelcastInstance.getName(), "wan-sync-stats-updater")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(WanConsistencyCheckEvent event, String wanReplicationName) throws Exception {
        String mapName = event.getObjectName();
        if (!this.isMapWanReplicated(mapName, wanReplicationName)) {
            String error = "WAN consistency check requested for map " + mapName + " that is not configured for WAN replication: " + wanReplicationName;
            this.nodeEngine.getManagementCenterService().log(new WanConsistencyCheckIgnoredEvent(event.getUuid(), this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName, error));
            throw new IllegalArgumentException(error);
        }
        String target = this.publisher.wanReplicationName + "/" + this.publisher.wanPublisherId;
        this.nodeEngine.getManagementCenterService().log(new WanConsistencyCheckStartedEvent(event.getUuid(), this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName));
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Checking via Merkle trees if map " + mapName + " is consistent with cluster " + target);
        }
        this.lastConsistencyCheckResults.put(mapName, new ConsistencyCheckResult(event.getUuid(), -1, -1, -1, -1, -1));
        ConsistencyCheckResult checkResult = new ConsistencyCheckResult(event.getUuid());
        try {
            List<Integer> localPartitionsToSync = this.getLocalPartitions(event);
            Map<Integer, int[]> diff = this.compareMerkleTrees(mapName, localPartitionsToSync);
            if (diff != null) {
                int totalLocalMerkleTreeLeaves = this.getMerkleTreeLeaves(diff) * localPartitionsToSync.size();
                checkResult = new ConsistencyCheckResult(event.getUuid(), localPartitionsToSync.size(), diff.size(), totalLocalMerkleTreeLeaves, this.getDiffLeafCount(diff), this.getEntriesToSync(mapName, diff));
                event.getProcessingResult().addProcessedPartitions(localPartitionsToSync);
            }
        }
        finally {
            this.lastConsistencyCheckResults.put(mapName, checkResult);
        }
        int entriesToSync = checkResult.getLastEntriesToSync();
        int checkedCount = checkResult.getLastCheckedPartitionCount();
        int diffCount = checkResult.getLastDiffPartitionCount();
        this.nodeEngine.getManagementCenterService().log(new WanConsistencyCheckFinishedEvent(event.getUuid(), this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName, diffCount, checkedCount, entriesToSync));
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Consistency check for map " + mapName + " with cluster " + target + " has completed: " + diffCount + " partitions out of " + checkedCount + " are not consistent, " + entriesToSync + " entries need to be synchronized.");
        }
    }

    private int getDiffLeafCount(Map<Integer, int[]> diff) {
        int diffLeafCount = 0;
        for (int[] pairs : diff.values()) {
            diffLeafCount += pairs.length / 2;
        }
        return diffLeafCount;
    }

    private int getMerkleTreeLeaves(Map<Integer, int[]> diff) {
        Iterator<int[]> iterator = diff.values().iterator();
        if (!iterator.hasNext()) {
            return 0;
        }
        int[] pairs = iterator.next();
        int level = MerkleTreeUtil.getLevelOfNode(pairs[0]);
        return MerkleTreeUtil.getNodesOnLevel(level);
    }

    private int getEntriesToSync(String mapName, Map<Integer, int[]> diff) {
        int entryCount = 0;
        for (Map.Entry<Integer, int[]> partitionDiffsEntry : diff.entrySet()) {
            Integer partitionId = partitionDiffsEntry.getKey();
            int[] merkleTreeNodeOrderValuePairs = partitionDiffsEntry.getValue();
            int[] merkleTreeNodeOrders = new int[merkleTreeNodeOrderValuePairs.length / 2];
            for (int i = 0; i < merkleTreeNodeOrders.length; ++i) {
                merkleTreeNodeOrders[i] = merkleTreeNodeOrderValuePairs[i * 2];
            }
            MerkleTreeGetEntryCountOperation op = new MerkleTreeGetEntryCountOperation(mapName, merkleTreeNodeOrders);
            InvocationFuture future = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", op, partitionId);
            Integer count = (Integer)((InternalCompletableFuture)future).joinInternal();
            entryCount += count.intValue();
        }
        return entryCount;
    }

    @Override
    public void removeReplicationEvent(WanEnterpriseMapEvent sync) {
        WanEnterpriseMapMerkleTreeNode node = (WanEnterpriseMapMerkleTreeNode)sync;
        WanSyncContext<WanMerkleTreeSyncStats> syncContext = this.syncContextMap.get(node.getUuid());
        int partitionId = node.getPartitionId();
        int nodeEntryCount = node.getEntryCount();
        String mapName = sync.getMapName();
        WanMerkleTreeSyncStats syncStats = syncContext.getSyncStats(mapName);
        this.updateOnPartitionSync(syncContext, nodeEntryCount, mapName, syncStats, partitionId);
    }

    private void updateOnPartitionSync(WanSyncContext<WanMerkleTreeSyncStats> syncContext, int nodeEntryCount, String mapName, WanMerkleTreeSyncStats syncStats, int partitionId) {
        this.updateSerializingExecutor.execute(() -> {
            int remainingEventCount = syncContext.getSyncCounter(mapName, partitionId).addAndGet(-nodeEntryCount);
            syncStats.onSyncLeaf(nodeEntryCount);
            if (remainingEventCount == 0) {
                syncStats.onSyncPartition();
                this.writeManagementCenterProgressUpdateEvent(syncContext.getUuid(), mapName, syncStats.getPartitionsSynced(), syncStats, syncStats.getRecordsSynced());
                this.completeSyncContext(syncContext, mapName, syncStats);
            }
        });
    }

    private void completeSyncContext(WanSyncContext<WanMerkleTreeSyncStats> syncContext, String mapName, WanMerkleTreeSyncStats syncStats) {
        if (syncStats.getPartitionsToSync() == syncStats.getPartitionsSynced()) {
            syncContext.onMapSynced();
            syncStats.onSyncComplete();
            this.logSyncStats(syncStats, mapName);
            this.writeManagementCenterSyncFinishedEvent(syncContext.getUuid(), mapName, syncStats);
            this.cleanupSyncContextMap();
        }
    }

    private void cleanupSyncContextMap() {
        for (Map.Entry<UUID, WanSyncContext<WanMerkleTreeSyncStats>> entry : this.syncContextMap.entrySet()) {
            UUID key = entry.getKey();
            WanSyncContext<WanMerkleTreeSyncStats> context = entry.getValue();
            if (!context.isCompletedOrStuck()) continue;
            this.syncContextMap.remove(key);
        }
    }

    @Override
    public void processEvent(WanSyncEvent event, String wanReplicationName) throws Exception {
        List<Integer> localPartitionsToSync = this.getLocalPartitions(event);
        UUID uuid = event.getUuid();
        if (event.getType() == WanSyncType.ALL_MAPS) {
            LinkedList<String> mapNames = new LinkedList<String>();
            this.mapService.getMapServiceContext().getMapContainers().keySet().forEach(mapName -> {
                if (this.isMapWanReplicated((String)mapName, wanReplicationName)) {
                    mapNames.add((String)mapName);
                }
            });
            if (!CollectionUtil.isEmpty(mapNames)) {
                WanSyncContext<WanMerkleTreeSyncStats> syncContext = new WanSyncContext<WanMerkleTreeSyncStats>(uuid, localPartitionsToSync.size(), mapNames);
                this.syncContextMap.put(uuid, syncContext);
                for (String mapName2 : mapNames) {
                    this.lastConsistencyCheckResults.put(mapName2, new ConsistencyCheckResult(uuid, -1, -1, -1, -1, -1));
                    this.processMapSync(event, syncContext, mapName2, localPartitionsToSync);
                }
            } else {
                this.nodeEngine.getManagementCenterService().log(new WanSyncIgnoredEvent(event.getUuid(), this.publisher.wanReplicationName, this.publisher.wanPublisherId, null, "No maps found to synchronize."));
            }
        } else {
            String mapName3 = event.getObjectName();
            if (!this.isMapWanReplicated(mapName3, wanReplicationName)) {
                String error = "WAN synchronization requested for map " + mapName3 + " that is not configured for WAN replication: " + wanReplicationName;
                this.nodeEngine.getManagementCenterService().log(new WanSyncIgnoredEvent(event.getUuid(), this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName3, error));
                throw new IllegalArgumentException(error);
            }
            this.lastConsistencyCheckResults.put(mapName3, new ConsistencyCheckResult(uuid, -1, -1, -1, -1, -1));
            WanSyncContext<WanMerkleTreeSyncStats> syncContext = new WanSyncContext<WanMerkleTreeSyncStats>(uuid, localPartitionsToSync.size(), Collections.singletonList(mapName3));
            this.syncContextMap.put(uuid, syncContext);
            this.processMapSync(event, syncContext, mapName3, localPartitionsToSync);
        }
    }

    private boolean isMapWanReplicated(String mapName, String wanReplicationName) {
        boolean legacyMode = this.nodeEngine.getProperties().getBoolean(SYNC_ALL_MAPS_LEGACY);
        MapContainer mapContainer = this.mapService.getMapServiceContext().getMapContainer(mapName);
        boolean isEnabled = mapContainer.isWanReplicationEnabled();
        return legacyMode ? isEnabled : isEnabled && mapContainer.getWanReplicationDelegate().getName().equals(wanReplicationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMapSync(WanSyncEvent event, WanSyncContext<WanMerkleTreeSyncStats> syncContext, String mapName, List<Integer> localPartitionsToSync) throws Exception {
        String target = this.publisher.wanReplicationName + "/" + this.publisher.wanPublisherId;
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Synchronizing map " + mapName + " to cluster " + target + " by using Merkle trees");
        }
        UUID uuid = event.getUuid();
        ConsistencyCheckResult checkResult = new ConsistencyCheckResult(uuid);
        try {
            this.nodeEngine.getManagementCenterService().log(new WanConsistencyCheckStartedEvent(uuid, this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName));
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Comparing Merkle trees of map " + mapName + " with cluster " + target + " to identify the difference");
            }
            Map<Integer, int[]> diff = this.compareMerkleTrees(mapName, localPartitionsToSync);
            Set<Integer> processedPartitions = event.getProcessingResult().getProcessedPartitions();
            if (diff == null || diff.isEmpty()) {
                WanMerkleTreeSyncStats stats = new WanMerkleTreeSyncStats(syncContext.getUuid(), 0);
                syncContext.addSyncStats(mapName, stats);
                this.lastSyncStats.put(mapName, stats);
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Map " + mapName + " found to be consistent with cluster " + target + ", no synchronization is needed");
                }
                this.nodeEngine.getManagementCenterService().log(new WanConsistencyCheckFinishedEvent(uuid, this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName, 0, localPartitionsToSync.size(), 0));
                this.nodeEngine.getManagementCenterService().log(new WanSyncStartedEvent(uuid, this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName));
                this.completeSyncContext(syncContext, mapName, syncContext.getSyncStats(mapName));
                return;
            }
            int entriesToSync = this.getEntriesToSync(mapName, diff);
            int totalLocalMerkleTreeLeaves = this.getMerkleTreeLeaves(diff) * localPartitionsToSync.size();
            checkResult = new ConsistencyCheckResult(uuid, localPartitionsToSync.size(), diff.size(), totalLocalMerkleTreeLeaves, this.getDiffLeafCount(diff), entriesToSync);
            this.nodeEngine.getManagementCenterService().log(new WanConsistencyCheckFinishedEvent(uuid, this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName, diff.size(), localPartitionsToSync.size(), entriesToSync));
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Merkle tree comparison for map " + mapName + " with cluster " + target + " has completed: " + diff.size() + " partitions out of " + localPartitionsToSync.size() + " need to be synced");
            }
            this.nodeEngine.getManagementCenterService().log(new WanSyncStartedEvent(uuid, this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName));
            this.syncDifferences(syncContext, mapName, diff, processedPartitions);
        }
        finally {
            this.lastConsistencyCheckResults.put(mapName, checkResult);
        }
    }

    private void syncDifferences(WanSyncContext<WanMerkleTreeSyncStats> syncContext, String mapName, Map<Integer, int[]> diff, Set<Integer> processedPartitions) {
        WanMerkleTreeSyncStats stats = new WanMerkleTreeSyncStats(syncContext.getUuid(), diff.size());
        syncContext.addSyncStats(mapName, stats);
        this.lastSyncStats.put(mapName, stats);
        for (Map.Entry<Integer, int[]> partitionDiffsEntry : diff.entrySet()) {
            Integer partitionId = partitionDiffsEntry.getKey();
            int[] merkleTreeNodeOrderValuePairs = partitionDiffsEntry.getValue();
            MerkleTreeGetEntriesOperation op = new MerkleTreeGetEntriesOperation(mapName, merkleTreeNodeOrderValuePairs);
            InvocationFuture future = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", op, partitionId);
            Collection partitionEntries = (Collection)((InternalCompletableFuture)future).joinInternal();
            AtomicInteger syncCounter = syncContext.getSyncCounter(mapName, partitionId);
            for (MerkleTreeNodeEntries nodeEntries : partitionEntries) {
                syncCounter.addAndGet(nodeEntries.getNodeEntries().size());
            }
            for (MerkleTreeNodeEntries nodeEntries : partitionEntries) {
                if (nodeEntries.getNodeEntries().isEmpty()) continue;
                WanEnterpriseMapMerkleTreeNode node = new WanEnterpriseMapMerkleTreeNode(syncContext.getUuid(), mapName, nodeEntries, partitionId);
                this.publisher.putToSyncEventQueue(node);
            }
            if (syncCounter.get() == 0) {
                this.updateOnPartitionSync(syncContext, 0, mapName, stats, partitionId);
            }
            processedPartitions.add(partitionId);
        }
    }

    private void logSyncStats(WanMerkleTreeSyncStats stats, String mapName) {
        String syncStatsMsg = String.format("Synchronization finished for map '%s' %n%nMerkle synchronization statistics:%n\t Synchronization UUID: %s%n\t Duration: %d secs%n\t Total records synchronized: %d%n\t Total partitions synchronized: %d%n\t Total Merkle tree nodes synchronized: %d%n\t Average records per Merkle tree node: %.2f%n\t StdDev of records per Merkle tree node: %.2f%n\t Minimum records per Merkle tree node: %d%n\t Maximum records per Merkle tree node: %d%n", mapName, stats.getUuid(), stats.getDurationSecs(), stats.getRecordsSynced(), stats.getPartitionsSynced(), stats.getNodesSynced(), stats.getAvgEntriesPerLeaf(), stats.getStdDevEntriesPerLeaf(), stats.getMinLeafEntryCount(), stats.getMaxLeafEntryCount());
        this.logger.info(syncStatsMsg);
    }

    private void writeManagementCenterSyncFinishedEvent(UUID uuid, String mapName, WanMerkleTreeSyncStats stats) {
        WanMerkleSyncFinishedEvent event = new WanMerkleSyncFinishedEvent(uuid, this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName, stats.getDurationSecs(), stats.getPartitionsSynced(), stats.getNodesSynced(), stats.getRecordsSynced(), stats.getMinLeafEntryCount(), stats.getMaxLeafEntryCount(), stats.getAvgEntriesPerLeaf(), stats.getStdDevEntriesPerLeaf());
        this.nodeEngine.getManagementCenterService().log(event);
    }

    private void writeManagementCenterProgressUpdateEvent(UUID uuid, String mapName, int partitionsSynced, WanMerkleTreeSyncStats stats, int recordsSynced) {
        WanSyncProgressUpdateEvent event = new WanSyncProgressUpdateEvent(uuid, this.publisher.wanReplicationName, this.publisher.wanPublisherId, mapName, stats.getPartitionsToSync(), partitionsSynced, recordsSynced);
        this.nodeEngine.getManagementCenterService().log(event);
    }

    private Map<Integer, int[]> compareMerkleTrees(String mapName, List<Integer> partitionIds) throws Exception {
        if (partitionIds.isEmpty()) {
            return null;
        }
        Map<Integer, int[]> diff = MapUtil.createHashMap(partitionIds.size());
        for (Integer partitionId : partitionIds) {
            diff.put(partitionId, new int[0]);
        }
        MerkleTreeComparisonProcessor processor = new MerkleTreeComparisonProcessor();
        while (true) {
            Map<Integer, int[]> localNodeValues = this.invokeLocal(mapName, diff);
            processor.processLocalNodeValues(localNodeValues);
            if (processor.isComparisonFinished()) {
                return processor.getDifference();
            }
            diff = localNodeValues;
            Map<Integer, int[]> remoteNodeValues = this.compareWithRemoteCluster(mapName, diff);
            processor.processRemoteNodeValues(remoteNodeValues);
            if (processor.isComparisonFinished()) {
                return processor.getDifference();
            }
            diff = remoteNodeValues;
        }
    }

    private Map<Integer, int[]> invokeLocal(String mapName, Map<Integer, int[]> diff) throws Exception {
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        MerkleTreeNodeCompareOperationFactory factory = new MerkleTreeNodeCompareOperationFactory(mapName, new MerkleTreeNodeValueComparison(diff));
        Set<Integer> differentPartitionIds = diff.keySet();
        return operationService.invokeOnPartitions("hz:impl:mapService", (OperationFactory)factory, differentPartitionIds);
    }

    private Map<Integer, int[]> removeIdenticalPartitions(Map<Integer, int[]> diff) {
        Iterator<Map.Entry<Integer, int[]>> iterator = diff.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, int[]> entry = iterator.next();
            int[] value = entry.getValue();
            if (value == null || value.length != 0) continue;
            iterator.remove();
        }
        return diff;
    }

    private Map<Integer, int[]> compareWithRemoteCluster(String mapName, Map<Integer, int[]> pairsByPartitionId) {
        List<Address> liveEndpoints = this.publisher.getConnectionManager().awaitAndGetTargetEndpoints();
        if (liveEndpoints.isEmpty()) {
            return null;
        }
        Integer randomPartitionId = pairsByPartitionId.keySet().iterator().next();
        Address randomTarget = liveEndpoints.get(randomPartitionId % liveEndpoints.size());
        MerkleTreeNodeValueComparison comparison = new MerkleTreeNodeValueComparison(pairsByPartitionId);
        WanMerkleTreeNodeCompareOperation compareOp = new WanMerkleTreeNodeCompareOperation(mapName, comparison);
        MerkleTreeNodeValueComparison comparisonResult = (MerkleTreeNodeValueComparison)this.invokeOnWanTarget(randomTarget, compareOp);
        HashMap<Integer, int[]> comparisonResultMap = new HashMap<Integer, int[]>(comparisonResult.getPartitionIds().size());
        for (int partitionId : comparisonResult.getPartitionIds()) {
            comparisonResultMap.put(partitionId, comparisonResult.getMerkleTreeNodeValues(partitionId));
        }
        return this.removeIdenticalPartitions(comparisonResultMap);
    }

    @Override
    public Map<String, ConsistencyCheckResult> getLastConsistencyCheckResults() {
        return this.lastConsistencyCheckResults;
    }

    @Override
    public Map<String, WanSyncStats> getLastSyncStats() {
        return Collections.unmodifiableMap(this.lastSyncStats);
    }

    @Override
    public void destroyMapData(String mapName) {
        this.lastConsistencyCheckResults.remove(mapName);
        this.lastSyncStats.remove(mapName);
    }

    private List<Integer> getLocalPartitions(WanAntiEntropyEvent event) {
        Set<Integer> partitionsToProcess = event.getPartitionSet();
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        LinkedList<Integer> localPartitionsToCheck = new LinkedList<Integer>();
        if (CollectionUtil.isEmpty(partitionsToProcess)) {
            for (IPartition partition : partitionService.getPartitions()) {
                if (!partition.isLocal()) continue;
                localPartitionsToCheck.add(partition.getPartitionId());
            }
        } else {
            for (Integer partitionId : partitionsToProcess) {
                InternalPartition partition = partitionService.getPartition(partitionId);
                if (!partition.isLocal()) continue;
                localPartitionsToCheck.add(partition.getPartitionId());
            }
        }
        return localPartitionsToCheck;
    }

    private <T> T invokeOnWanTarget(Address target, Operation operation) {
        long deadline = this.calculateDeadline();
        int idleStep = 0;
        while (System.nanoTime() < deadline || idleStep < 10) {
            WanConnectionWrapper connectionWrapper = this.publisher.getConnectionManager().getConnection(target);
            if (connectionWrapper != null) {
                String serviceName = "hz:core:wanReplicationService";
                OperationServiceImpl operationService = this.nodeEngine.getOperationService();
                Address targetAddress = connectionWrapper.getTargetAddress();
                InvocationFuture future = operationService.createInvocationBuilder(serviceName, operation, targetAddress).setTryCount(1).setConnectionManager(connectionWrapper.getConnection().getConnectionManager()).setCallTimeout(this.configurationContext.getResponseTimeoutMillis()).invoke();
                return (T)((InternalCompletableFuture)future).joinInternal();
            }
            this.wanTargetInvocationIdleStrategy.idle(idleStep++);
        }
        throw new IllegalStateException("Could not obtain a connection to " + target + " within " + 10 + " seconds after " + idleStep + " attempts");
    }

    private long calculateDeadline() {
        return System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
    }
}

