/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.enterprise.wan.impl.FinalizableEnterpriseWanEvent;
import com.hazelcast.enterprise.wan.impl.PublisherQueueContainer;
import com.hazelcast.enterprise.wan.impl.replication.WanConfigurationContext;
import com.hazelcast.instance.impl.Node;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;

public class PollSynchronizerPublisherQueueContainer
extends PublisherQueueContainer {
    private final AtomicReferenceArray<ReentrantLock> partitionPollLocks;

    PollSynchronizerPublisherQueueContainer(Node node, WanConfigurationContext configurationContext) {
        super(node, configurationContext);
        int partitionCount = node.getNodeEngine().getPartitionService().getPartitionCount();
        this.partitionPollLocks = new AtomicReferenceArray(partitionCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drainRandomWanQueue(int partitionId, Collection<FinalizableEnterpriseWanEvent> drainTo, int elementsToDrain) {
        ReentrantLock partitionPollLock = this.getPartitionPollLock(partitionId);
        if (partitionPollLock.tryLock()) {
            try {
                super.drainRandomWanQueue(partitionId, drainTo, elementsToDrain);
            }
            finally {
                partitionPollLock.unlock();
            }
        }
    }

    void blockPollingPartition(int partitionId) {
        ReentrantLock pollLock = this.getPartitionPollLock(partitionId);
        pollLock.lock();
    }

    void unblockPollingPartition(int partitionId) {
        ReentrantLock pollLock = this.getPartitionPollLock(partitionId);
        if (pollLock.isLocked()) {
            pollLock.unlock();
        }
    }

    private ReentrantLock getPartitionPollLock(int partitionId) {
        ReentrantLock lock = this.partitionPollLocks.get(partitionId);
        if (lock != null) {
            return lock;
        }
        this.partitionPollLocks.compareAndSet(partitionId, null, new ReentrantLock());
        return this.partitionPollLocks.get(partitionId);
    }
}

