/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.AbstractWanPublisherConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.enterprise.wan.impl.connection.WanConnectionManager;
import com.hazelcast.enterprise.wan.impl.discovery.StaticDiscoveryProperties;
import com.hazelcast.enterprise.wan.impl.discovery.StaticDiscoveryStrategy;
import com.hazelcast.enterprise.wan.impl.replication.AbstractWanPublisher;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.discovery.impl.PredefinedDiscoveryService;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractWanReplication
extends AbstractWanPublisher {
    WanConnectionManager connectionManager;
    private DiscoveryService discoveryService;

    @Override
    public void init(WanReplicationConfig wanReplicationConfig, AbstractWanPublisherConfig publisherConfig) {
        WanBatchPublisherConfig batchReplicationConfig = (WanBatchPublisherConfig)publisherConfig;
        super.init(wanReplicationConfig, publisherConfig);
        this.discoveryService = Preconditions.checkNotNull(this.createDiscoveryService(batchReplicationConfig));
        this.discoveryService.start();
        this.connectionManager = new WanConnectionManager(this.node, this.discoveryService);
        this.connectionManager.init(this.configurationContext);
    }

    private DiscoveryService createDiscoveryService(WanBatchPublisherConfig config) {
        boolean discoveryEnabled;
        String endpoints = this.configurationContext.getEndpoints();
        DiscoveryConfig discoveryConfig = config.getDiscoveryConfig();
        boolean endpointsConfigured = !StringUtil.isNullOrEmpty(endpoints);
        boolean bl = discoveryEnabled = discoveryConfig != null && discoveryConfig.isEnabled() || !AliasedDiscoveryConfigUtils.createDiscoveryStrategyConfigs(config).isEmpty();
        if (endpointsConfigured) {
            if (discoveryEnabled) {
                throw AbstractWanReplication.ambiguousPublisherConfig();
            }
            return new PredefinedDiscoveryService(this.staticDiscoveryStrategy(endpoints));
        }
        if (discoveryEnabled) {
            return this.node.createDiscoveryService(config.getDiscoveryConfig(), AliasedDiscoveryConfigUtils.createDiscoveryStrategyConfigs(config), false, this.node.getLocalMember());
        }
        throw new InvalidConfigurationException("There are no methods of defining publisher endpoints. Either use the the discovery configuration or define static endpoints");
    }

    private static InvalidConfigurationException ambiguousPublisherConfig() {
        return new InvalidConfigurationException("The publisher endpoint configuration is ambiguous. Either use the the discovery configuration or define static endpoints");
    }

    private StaticDiscoveryStrategy staticDiscoveryStrategy(String endpoints) {
        HashMap<String, Comparable> properties = new HashMap<String, Comparable>();
        properties.put(StaticDiscoveryProperties.ENDPOINTS.key(), (Comparable)((Object)endpoints));
        properties.put(StaticDiscoveryProperties.PORT.key(), Integer.valueOf(this.node.getConfig().getNetworkConfig().getPort()));
        return new StaticDiscoveryStrategy(this.logger, properties);
    }

    @Override
    public boolean isConnected() {
        return this.connectionManager.isConnected();
    }

    public List<Address> getTargetEndpoints() {
        return this.connectionManager.getTargetEndpoints();
    }

    public WanConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    protected void afterShutdown() {
        super.afterShutdown();
        this.connectionManager.shutdown();
        if (this.discoveryService != null) {
            try {
                this.discoveryService.destroy();
            }
            catch (Exception e) {
                this.logger.warning("Could not destroy discovery service", e);
            }
        }
    }
}

