/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.enterprise.wan.impl.WanAcknowledger;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class WanThrottlingAcknowledger
implements WanAcknowledger {
    private static final int THRESHOLD_LOGGER_PERIOD_MILLIS = (int)TimeUnit.MINUTES.toMillis(5L);
    private static final int NO_CURRENT_DELAYING = -1;
    private final int invocationThreshold;
    private final Node node;
    private final int backoffInit;
    private final int backoffMax;
    private final float backoffMultiplier;
    private final Object queueLock = new Object();
    private final ILogger logger;
    private final Queue<DelayedAcknowledgment> delayedAckQueue = new LinkedList<DelayedAcknowledgment>();
    private final AtomicReference<DelayingState> delayingState = new AtomicReference<DelayingState>(DelayingState.NOT_DELAYING);
    private InvocationRegistry invocationRegistry;
    private TaskScheduler wanScheduler;
    private volatile long lastThresholdLogMs;
    private volatile DelayingMetrics metrics = new DelayingMetrics();

    public WanThrottlingAcknowledger(Node node, int invocationThreshold) {
        this.invocationThreshold = invocationThreshold;
        this.node = node;
        HazelcastProperties properties = node.getProperties();
        this.backoffInit = properties.getInteger(ClusterProperty.WAN_CONSUMER_ACK_DELAY_BACKOFF_INIT_MS);
        this.backoffMax = properties.getInteger(ClusterProperty.WAN_CONSUMER_ACK_DELAY_BACKOFF_MAX_MS);
        this.backoffMultiplier = properties.getFloat(ClusterProperty.WAN_CONSUMER_ACK_DELAY_BACKOFF_MULTIPLIER);
        this.logger = node.getLogger(WanThrottlingAcknowledger.class);
        this.logger.info("Using throttling WAN acknowledgement strategy with pending invocation threshold " + invocationThreshold);
    }

    @Override
    public void acknowledgeSuccess(Operation operation) {
        this.acknowledge(operation, true);
    }

    @Override
    public void acknowledgeFailure(Operation operation) {
        this.acknowledge(operation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(Operation operation, boolean success) {
        boolean thresholdExceeded;
        int pendingInvocations = this.invocationRegistry().size();
        boolean bl = thresholdExceeded = pendingInvocations >= this.invocationThreshold;
        if (!thresholdExceeded && this.delayingState.get() != DelayingState.DELAYING) {
            operation.sendResponse(success);
        } else {
            Object object = this.queueLock;
            synchronized (object) {
                this.delayedAckQueue.offer(new DelayedAcknowledgment(operation, success));
                if (this.delayingState.compareAndSet(DelayingState.NOT_DELAYING, DelayingState.DELAYING)) {
                    this.delayingStarted();
                    new HealthConditionCheckTask().schedule();
                }
                if (thresholdExceeded) {
                    this.log(pendingInvocations);
                }
            }
        }
    }

    private void log(int pendingInvocations) {
        String logMessage = String.format("Pending invocation threshold exceeded, delaying WAN acknowledgments. Pending invocations: %d, threshold: %d", pendingInvocations, this.invocationThreshold);
        long curTime = System.currentTimeMillis();
        if (curTime > this.lastThresholdLogMs + (long)THRESHOLD_LOGGER_PERIOD_MILLIS) {
            this.lastThresholdLogMs = curTime;
            this.logger.warning(logMessage);
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(logMessage);
        }
    }

    private InvocationRegistry invocationRegistry() {
        if (this.invocationRegistry != null) {
            return this.invocationRegistry;
        }
        this.invocationRegistry = this.node.getNodeEngine().getOperationService().getInvocationRegistry();
        return this.invocationRegistry;
    }

    private void delayingStarted() {
        this.metrics = this.metrics.copyWith(copy -> {
            ((DelayingMetrics)copy).lastStartTimestamp = System.currentTimeMillis();
            ((DelayingMetrics)copy).totalCount++;
        });
    }

    private void delayingEnded() {
        this.metrics = this.metrics.copyWith(copy -> {
            long now = System.currentTimeMillis();
            ((DelayingMetrics)copy).lastEndTimestamp = now;
            DelayingMetrics delayingMetrics = copy;
            delayingMetrics.totalDelayMillis = (int)((long)delayingMetrics.totalDelayMillis + (now - ((DelayingMetrics)copy).lastStartTimestamp));
        });
    }

    void provideMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        DelayingMetrics collectedMetrics = this.metrics;
        context.collect(descriptor, collectedMetrics);
        boolean ongoingDelaying = collectedMetrics.lastStartTimestamp > collectedMetrics.lastEndTimestamp;
        long currentDelayingMillis = ongoingDelaying ? System.currentTimeMillis() - this.metrics.lastStartTimestamp : -1L;
        context.collect(descriptor.withMetric("ackDelayCurrentMillis").withUnit(ProbeUnit.MS), currentDelayingMillis);
    }

    static final class DelayingMetrics {
        @Probe(name="ackDelayTotalCount")
        private int totalCount;
        @Probe(name="ackDelayTotalMillis", unit=ProbeUnit.MS)
        private int totalDelayMillis;
        @Probe(name="ackDelayLastStart", unit=ProbeUnit.MS)
        private long lastStartTimestamp;
        @Probe(name="ackDelayLastEnd", unit=ProbeUnit.MS)
        private long lastEndTimestamp;

        DelayingMetrics() {
        }

        private DelayingMetrics copy() {
            DelayingMetrics copy = new DelayingMetrics();
            copy.totalCount = this.totalCount;
            copy.totalDelayMillis = this.totalDelayMillis;
            copy.lastStartTimestamp = this.lastStartTimestamp;
            copy.lastEndTimestamp = this.lastEndTimestamp;
            return copy;
        }

        private DelayingMetrics copyWith(Consumer<DelayingMetrics> mutator) {
            DelayingMetrics copy = this.copy();
            mutator.accept(copy);
            return copy;
        }

        public String toString() {
            return "DelayingMetrics{totalCount=" + this.totalCount + ", totalDelayMillis=" + this.totalDelayMillis + ", lastStartTimeStamp=" + this.lastStartTimestamp + ", lastEndTimeStamp=" + this.lastEndTimestamp + '}';
        }
    }

    private static enum DelayingState {
        NOT_DELAYING,
        DELAYING;

    }

    private static final class DelayedAcknowledgment
    implements Runnable {
        private final Operation operation;
        private final boolean success;

        private DelayedAcknowledgment(Operation operation, boolean success) {
            this.operation = operation;
            this.success = success;
        }

        @Override
        public void run() {
            this.operation.sendResponse(this.success);
        }
    }

    private final class HealthConditionCheckTask
    implements Runnable {
        private long delayMicros = -1L;

        private HealthConditionCheckTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (WanThrottlingAcknowledger.this.invocationRegistry.size() < WanThrottlingAcknowledger.this.invocationThreshold) {
                ArrayList<DelayedAcknowledgment> acks = new ArrayList<DelayedAcknowledgment>(WanThrottlingAcknowledger.this.delayedAckQueue.size());
                Iterator iterator = WanThrottlingAcknowledger.this.queueLock;
                synchronized (iterator) {
                    DelayedAcknowledgment delayedAck;
                    while ((delayedAck = (DelayedAcknowledgment)WanThrottlingAcknowledger.this.delayedAckQueue.poll()) != null) {
                        acks.add(delayedAck);
                    }
                    WanThrottlingAcknowledger.this.delayingEnded();
                    WanThrottlingAcknowledger.this.delayingState.set(DelayingState.NOT_DELAYING);
                }
                for (DelayedAcknowledgment ack : acks) {
                    this.wanScheduler().execute(ack);
                }
            } else {
                this.schedule();
            }
        }

        public void schedule() {
            this.wanScheduler().schedule(this, this.delay(), TimeUnit.MICROSECONDS);
        }

        private long delay() {
            this.delayMicros = this.delayMicros > 0L ? (long)Math.min((float)this.delayMicros * WanThrottlingAcknowledger.this.backoffMultiplier, (float)WanThrottlingAcknowledger.this.backoffMax) : (long)WanThrottlingAcknowledger.this.backoffInit;
            return this.delayMicros;
        }

        private TaskScheduler wanScheduler() {
            if (WanThrottlingAcknowledger.this.wanScheduler != null) {
                return WanThrottlingAcknowledger.this.wanScheduler;
            }
            WanThrottlingAcknowledger.this.wanScheduler = WanThrottlingAcknowledger.this.node.getNodeEngine().getExecutionService().getTaskScheduler("wan-ack-throttle");
            return WanThrottlingAcknowledger.this.wanScheduler;
        }
    }
}

