/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Preconditions;

public class DistributedObjectEntryIdentifier {
    private final String serviceName;
    private final String objectName;
    private final Data key;

    public DistributedObjectEntryIdentifier(String serviceName, String objectName, Data key) {
        this.serviceName = Preconditions.checkNotNull(serviceName, "Service name must not be null");
        this.objectName = Preconditions.checkNotNull(objectName, "Object name must not be null");
        this.key = Preconditions.checkNotNull(key, "Entry key must not be null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DistributedObjectEntryIdentifier)) return false;
        DistributedObjectEntryIdentifier that = (DistributedObjectEntryIdentifier)o;
        if (!this.serviceName.equals(that.serviceName)) return false;
        if (!this.objectName.equals(that.objectName)) return false;
        if (!this.key.equals(that.key)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.serviceName.hashCode();
        result = 31 * result + this.objectName.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }
}

