/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.wan;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.cache.impl.EnterpriseCacheService;
import com.hazelcast.cache.impl.PreJoinCacheConfig;
import com.hazelcast.cache.impl.operation.EnterpriseCacheOperationProvider;
import com.hazelcast.cache.impl.wan.WanEnterpriseCacheAddOrUpdateEvent;
import com.hazelcast.cache.impl.wan.WanEnterpriseCacheEvent;
import com.hazelcast.cache.impl.wan.WanEnterpriseCacheRemoveEvent;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.WanSupportingService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.proxyservice.ProxyService;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.impl.InternalWanEvent;
import com.hazelcast.wan.impl.WanReplicationService;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletionStage;

public class WanCacheSupportingService
implements WanSupportingService {
    public static final UUID ORIGIN = UuidUtil.NIL_UUID;
    private final EnterpriseCacheService cacheService;
    private final NodeEngine nodeEngine;
    private final ProxyService proxyService;
    private final WanReplicationService wanService;

    public WanCacheSupportingService(EnterpriseCacheService cacheService) {
        this.cacheService = cacheService;
        this.nodeEngine = cacheService.getNodeEngine();
        this.proxyService = this.nodeEngine.getProxyService();
        this.wanService = this.nodeEngine.getWanReplicationService();
    }

    @Override
    public void onReplicationEvent(InternalWanEvent event, WanAcknowledgeType acknowledgeType) {
        if (!(event instanceof WanEnterpriseCacheEvent)) {
            return;
        }
        WanEnterpriseCacheEvent wanCacheEvent = (WanEnterpriseCacheEvent)event;
        CacheConfig cacheConfig = this.getCacheConfig(wanCacheEvent);
        UUID source = this.nodeEngine.getLocalMember().getUuid();
        this.proxyService.getDistributedObject("hz:impl:cacheService", cacheConfig.getNameWithPrefix(), source);
        this.republishIfNecessary(event, cacheConfig);
        if (wanCacheEvent instanceof WanEnterpriseCacheAddOrUpdateEvent) {
            this.handleAddOrUpdateEvent((WanEnterpriseCacheAddOrUpdateEvent)wanCacheEvent, cacheConfig, acknowledgeType);
            this.wanService.getReceivedEventCounters("hz:impl:cacheService").incrementUpdate(wanCacheEvent.getNameWithPrefix());
        } else if (wanCacheEvent instanceof WanEnterpriseCacheRemoveEvent) {
            this.handleRemoveEvent((WanEnterpriseCacheRemoveEvent)wanCacheEvent, cacheConfig, acknowledgeType);
            this.wanService.getReceivedEventCounters("hz:impl:cacheService").incrementRemove(wanCacheEvent.getNameWithPrefix());
        }
    }

    @Override
    public CompletionStage<Void> onSyncBatch(Collection<InternalWanEvent> batch, WanAcknowledgeType acknowledgeType) {
        throw new UnsupportedOperationException("WAN Synchronization isn't supported for ICache");
    }

    private void republishIfNecessary(InternalWanEvent event, CacheConfig cacheConfig) {
        WanReplicationRef wanReplicationRef = cacheConfig.getWanReplicationRef();
        if (wanReplicationRef != null && wanReplicationRef.isRepublishingEnabled()) {
            this.cacheService.publishWanEvent(cacheConfig.getNameWithPrefix(), event);
        }
    }

    private CacheConfig getCacheConfig(WanEnterpriseCacheEvent wanCacheEvent) {
        CacheConfig cacheConfig;
        try {
            cacheConfig = this.getLocalCacheConfig(wanCacheEvent.getNameWithPrefix(), wanCacheEvent.getCacheName());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        CacheConfig existingCacheConfig = this.cacheService.putCacheConfigIfAbsent(cacheConfig);
        if (existingCacheConfig == null) {
            this.cacheService.createCacheConfigOnAllMembers(PreJoinCacheConfig.of(cacheConfig));
        }
        return cacheConfig;
    }

    private CacheConfig getLocalCacheConfig(String cacheNameWithPrefix, String cacheSimpleName) {
        CacheConfig cacheConfig = this.cacheService.getCacheConfig(cacheNameWithPrefix);
        if (cacheConfig == null) {
            cacheConfig = this.cacheService.findCacheConfig(cacheSimpleName);
            if (cacheConfig == null) {
                throw new CacheNotExistsException("Couldn't find cache config with name " + cacheNameWithPrefix);
            }
            cacheConfig.setManagerPrefix(cacheNameWithPrefix.substring(0, cacheNameWithPrefix.lastIndexOf(cacheSimpleName)));
        }
        return cacheConfig;
    }

    private void handleRemoveEvent(WanEnterpriseCacheRemoveEvent event, CacheConfig cacheConfig, WanAcknowledgeType acknowledgeType) {
        EnterpriseCacheOperationProvider operationProvider = (EnterpriseCacheOperationProvider)this.cacheService.getCacheOperationProvider(event.getNameWithPrefix(), cacheConfig.getInMemoryFormat());
        Operation operation = operationProvider.createWanRemoveOperation(ORIGIN, event.getKey(), -1);
        InternalCompletableFuture future = this.invokeOnPartition(event.getKey(), operation);
        if (future != null && acknowledgeType == WanAcknowledgeType.ACK_ON_OPERATION_COMPLETE) {
            future.joinInternal();
        }
    }

    private void handleAddOrUpdateEvent(WanEnterpriseCacheAddOrUpdateEvent event, CacheConfig cacheConfig, WanAcknowledgeType acknowledgeType) {
        EnterpriseCacheOperationProvider operationProvider = (EnterpriseCacheOperationProvider)this.cacheService.getCacheOperationProvider(event.getNameWithPrefix(), cacheConfig.getInMemoryFormat());
        SplitBrainMergePolicy mergePolicy = this.cacheService.getMergePolicyProvider().getMergePolicy(event.getMergePolicy());
        SplitBrainMergeTypes.CacheMergeTypes<Object, Object> mergingEntry = MergingValueFactory.createMergingEntry(this.nodeEngine.getSerializationService(), event.getEntryView());
        Operation operation = operationProvider.createWanMergeOperation(mergingEntry, mergePolicy, -1);
        InternalCompletableFuture future = this.invokeOnPartition(event.getKey(), operation);
        if (future != null && acknowledgeType == WanAcknowledgeType.ACK_ON_OPERATION_COMPLETE) {
            future.joinInternal();
        }
    }

    private InternalCompletableFuture invokeOnPartition(Data key, Operation operation) {
        try {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(key);
            return this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:cacheService", operation, partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }
}

