/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.BackupAwareKeyBasedHiDensityCacheOperation;
import com.hazelcast.cache.impl.hidensity.operation.CachePutBackupOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;

public class CacheGetAndReplaceOperation
extends BackupAwareKeyBasedHiDensityCacheOperation
implements MutableOperation,
MutatingOperation {
    private Data value;
    private ExpiryPolicy expiryPolicy;

    public CacheGetAndReplaceOperation() {
    }

    public CacheGetAndReplaceOperation(String name, Data key, Data value, ExpiryPolicy expiryPolicy) {
        super(name, key);
        this.value = value;
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    protected void runInternal() {
        this.response = this.recordStore.getAndReplace(this.key, this.value, this.expiryPolicy, this.getCallerUuid(), this.completionId);
    }

    @Override
    public void afterRun() throws Exception {
        if (this.response != null) {
            this.publishWanUpdate(this.key, this.recordStore.getRecord(this.key));
        }
        super.afterRun();
        this.dispose();
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        serializationService.disposeData(this.key);
        if (this.response == null) {
            serializationService.disposeData(this.value);
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.response != null && this.recordStore.getRecord(this.key) != null;
    }

    @Override
    public Operation getBackupOperation() {
        CacheRecord record = this.recordStore.getRecord(this.key);
        return new CachePutBackupOperation(this.name, this.key, this.value, this.expiryPolicy, record.getCreationTime());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData(out, this.value);
        out.writeObject(this.expiryPolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.value = CacheGetAndReplaceOperation.readNativeMemoryOperationData(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
    }

    @Override
    public int getClassId() {
        return 7;
    }
}

