/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.nativememory;

import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecord;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecordMap;
import com.hazelcast.internal.eviction.EvictionCandidate;
import com.hazelcast.internal.eviction.EvictionListener;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.impl.KeyOffHeap;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HotRestartHiDensityNativeMemoryCacheRecordMap
extends HiDensityNativeMemoryCacheRecordMap {
    private final Object mutex = new Object();
    private final List<KeyOffHeap> evictedKeys = new ArrayList<KeyOffHeap>();
    private final EnterpriseSerializationService serializationService;
    private HotRestartStore hotRestartStore;
    private long prefix;
    private boolean fsync;

    public HotRestartHiDensityNativeMemoryCacheRecordMap(int initialCapacity, HiDensityRecordProcessor cacheRecordProcessor, HiDensityStorageInfo cacheInfo, EnterpriseSerializationService serializationService) {
        super(initialCapacity, cacheRecordProcessor, cacheInfo);
        this.serializationService = serializationService;
    }

    Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HiDensityNativeMemoryCacheRecord put(Data key, HiDensityNativeMemoryCacheRecord value) {
        Object object = this.mutex;
        synchronized (object) {
            return super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(Data key, HiDensityNativeMemoryCacheRecord value) {
        Object object = this.mutex;
        synchronized (object) {
            return super.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HiDensityNativeMemoryCacheRecord putIfAbsent(Data key, HiDensityNativeMemoryCacheRecord value) {
        Object object = this.mutex;
        synchronized (object) {
            return super.putIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HiDensityNativeMemoryCacheRecord replace(Data key, HiDensityNativeMemoryCacheRecord value) {
        Object object = this.mutex;
        synchronized (object) {
            return super.replace(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Data key) {
        Object object = this.mutex;
        synchronized (object) {
            return super.delete(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object k, Object v) {
        Object object = this.mutex;
        synchronized (object) {
            return super.remove(k, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Data key, HiDensityNativeMemoryCacheRecord oldValue, HiDensityNativeMemoryCacheRecord newValue) {
        Object object = this.mutex;
        synchronized (object) {
            return super.replace(key, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HiDensityNativeMemoryCacheRecord remove(Object k) {
        Object object = this.mutex;
        synchronized (object) {
            return (HiDensityNativeMemoryCacheRecord)super.remove(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends EvictionCandidate<Data, HiDensityNativeMemoryCacheRecord>> int forceEvict(int evictionPercentage, EvictionListener<Data, HiDensityNativeMemoryCacheRecord> evictionListener) {
        int evictedCount;
        Object object = this.mutex;
        synchronized (object) {
            evictedCount = super.forceEvict(evictionPercentage, evictionListener);
        }
        this.evictKeysFromHotRestartStore();
        return evictedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends EvictionCandidate<Data, HiDensityNativeMemoryCacheRecord>> boolean tryEvict(C evictionCandidate, EvictionListener<Data, HiDensityNativeMemoryCacheRecord> evictionListener) {
        boolean evicted;
        Object object = this.mutex;
        synchronized (object) {
            evicted = super.tryEvict(evictionCandidate, evictionListener);
        }
        this.evictKeysFromHotRestartStore();
        return evicted;
    }

    private void evictKeysFromHotRestartStore() {
        for (KeyOffHeap key : this.evictedKeys) {
            this.hotRestartStore.remove(key, this.fsync);
        }
        this.evictedKeys.clear();
    }

    @Override
    public void onEvict(Data key, HiDensityNativeMemoryCacheRecord record, boolean wasExpired) {
        super.onEvict(key, record, wasExpired);
        NativeMemoryData nativeKey = (NativeMemoryData)key;
        assert (nativeKey.address() != 0L);
        assert (record.address() != 0L);
        assert (record.getValueAddress() != 0L);
        KeyOffHeap hotRestartKey = new KeyOffHeap(this.prefix, key.toByteArray(), nativeKey.address(), record.getSequence());
        this.evictedKeys.add(hotRestartKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends Data, ? extends HiDensityNativeMemoryCacheRecord> map) {
        Object object = this.mutex;
        synchronized (object) {
            super.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.mutex;
        synchronized (object) {
            super.dispose();
        }
    }

    void setPrefix(long prefix) {
        this.prefix = prefix;
    }

    void setHotRestartStore(HotRestartStore hotRestartStore) {
        this.hotRestartStore = hotRestartStore;
    }

    void setFsync(boolean fsync) {
        this.fsync = fsync;
    }
}

