/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.auditlog.impl;

import com.hazelcast.auditlog.AuditableEvent;
import com.hazelcast.auditlog.AuditlogService;
import com.hazelcast.auditlog.EventBuilder;
import com.hazelcast.auditlog.Level;
import com.hazelcast.auditlog.impl.SimpleEvent;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import java.util.Map;

public class ILoggerAuditlogService
implements AuditlogService {
    public static final String AUDITLOG_CATEGORY = "hazelcast.auditlog";
    private final ILogger logger;

    public ILoggerAuditlogService(LoggingService loggingService) {
        this.logger = loggingService != null ? loggingService.getLogger(AUDITLOG_CATEGORY) : Logger.getLogger(AUDITLOG_CATEGORY);
    }

    @Override
    public void log(AuditableEvent auditableEvent) {
        this.logInternal(auditableEvent.typeId(), auditableEvent.level(), auditableEvent.message(), auditableEvent.parameters(), auditableEvent.cause());
    }

    @Override
    public void log(String eventTypeId, Level level, String message) {
        this.logInternal(eventTypeId, level, message, null, null);
    }

    @Override
    public void log(String eventTypeId, Level level, String message, Throwable thrown) {
        this.logInternal(eventTypeId, level, message, null, thrown);
    }

    @Override
    public EventBuilder<?> eventBuilder(String typeId) {
        return SimpleEvent.builder(typeId, this);
    }

    private java.util.logging.Level toJulLevel(Level level) {
        switch (level) {
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
        }
        throw new IllegalArgumentException("Unknown Level " + (Object)((Object)level));
    }

    private void logInternal(String typeId, Level level, String message, Map<String, Object> parameters, Throwable cause) {
        java.util.logging.Level julLevel = this.toJulLevel(level);
        if (!this.logger.isLoggable(julLevel)) {
            return;
        }
        StringBuilder sb = new StringBuilder(typeId).append(":");
        if (message != null) {
            sb.append(message);
        }
        sb.append(":");
        if (parameters != null && !parameters.isEmpty()) {
            sb.append(parameters);
        }
        if (cause != null) {
            this.logger.log(julLevel, sb.toString(), cause);
        } else {
            this.logger.log(julLevel, sb.toString());
        }
    }
}

