/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.avro;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import org.apache.avro.util.Utf8;

class AvroSerializerHooks {
    AvroSerializerHooks() {
    }

    public static final class Utf8Hook
    implements SerializerHook<Utf8> {
        public Class<Utf8> getSerializationType() {
            return Utf8.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<Utf8>(){

                public int getTypeId() {
                    return -329;
                }

                public void write(ObjectDataOutput out, Utf8 object) throws IOException {
                    out.writeByteArray(object.getBytes());
                }

                public Utf8 read(ObjectDataInput in) throws IOException {
                    return new Utf8(in.readByteArray());
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }
}

