/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final String MASK_FOR_SENSITIVE_DATA = "****";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)(\\.(\\d+))?(-\\w+(?:-\\d+)?)?(-SNAPSHOT)?$");
    private static final Pattern ALPHANUMERIC_WITH_DASH_AND_UNDERSCORE = Pattern.compile("[^a-zA-Z0-9_\\-]");

    private StringUtil() {
    }

    public static boolean isNullOrEmptyAfterTrim(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static String[] tokenizeVersionString(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String[] tokens = new String[matcher.groupCount()];
            for (int i = 0; i < matcher.groupCount(); ++i) {
                tokens[i] = matcher.group(i + 1);
            }
            return tokens;
        }
        return null;
    }

    public static boolean isAlphanumericWithDashAndUnderscore(String s) {
        return !ALPHANUMERIC_WITH_DASH_AND_UNDERSCORE.matcher(s).find();
    }

    public static boolean isValidVersion(String s) {
        return s != null && VERSION_PATTERN.matcher(s).matches();
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int length = searchStr.length();
        if (length == 0) {
            return true;
        }
        for (int i = str.length() - length; i >= 0; --i) {
            if (!str.regionMatches(true, i, searchStr, 0, length)) continue;
            return true;
        }
        return false;
    }
}

