/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.prometheus;

import java.io.IOException;
import java.io.UncheckedIOException;

class PrometheusTokenPrinter {
    private final Appendable output;

    PrometheusTokenPrinter(Appendable output) {
        this.output = output;
    }

    static String toPrometheusCompliantMetricName(String name) {
        try {
            StringBuilder writer = new StringBuilder();
            new PrometheusTokenPrinter((Appendable)writer).printMetricName(name);
            return writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    PrometheusTokenPrinter printMetricName(String rawMetricName) throws IOException {
        this.output.append("hz_");
        this.printTagName(rawMetricName);
        return this;
    }

    PrometheusTokenPrinter printTagName(String rawName) throws IOException {
        for (int i = 0; i < rawName.length(); ++i) {
            char ch = rawName.charAt(i);
            if (ch == '.' || ch == ':' || ch == '-') {
                this.output.append('_');
                continue;
            }
            this.output.append(ch);
        }
        return this;
    }

    PrometheusTokenPrinter printLabelValue(String s) throws IOException {
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    this.output.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    this.output.append("\\\"");
                    continue block5;
                }
                case '\n': {
                    this.output.append("\\n");
                    continue block5;
                }
                default: {
                    this.output.append(c);
                }
            }
        }
        return this;
    }

    PrometheusTokenPrinter print(char ch) throws IOException {
        this.output.append(ch);
        return this;
    }

    PrometheusTokenPrinter print(String str) throws IOException {
        this.output.append(str);
        return this;
    }
}

