/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.prometheus;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.EnvProperty;
import com.hazelcast.webmonitor.config.properties.PrometheusExporterConfigurationProperties;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Tags;
import com.hazelcast.webmonitor.service.Licensed;
import com.hazelcast.webmonitor.service.metrics.DataPointsReceivedEvent;
import com.hazelcast.webmonitor.service.metrics.MetricsTraceLogger;
import com.hazelcast.webmonitor.service.prometheus.DataPointFilter;
import com.hazelcast.webmonitor.service.prometheus.PrometheusExporter;
import com.hazelcast.webmonitor.service.prometheus.PrometheusExporterImpl;
import com.hazelcast.webmonitor.service.prometheus.PrometheusTokenPrinter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class PrometheusExporterImpl
implements PrometheusExporter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusExporterImpl.class);
    public static final String PROMETHEUS_RESPONSE_CONTENT_TYPE = "text/plain; version=0.0.4; charset=utf-8";
    static final int TTL_IN_SECONDS = 90;
    private final Cache<Key, PrometheusExportableValue> store = Caffeine.newBuilder().expireAfterWrite(90L, TimeUnit.SECONDS).build();
    private final boolean enabled;
    private final Predicate<MetricDataPoint> filter;
    private final MetricsTraceLogger metricsTraceLogger;
    private volatile boolean loggedDisabledWarning;
    private volatile boolean requestReceived;

    PrometheusExporterImpl(PrometheusExporterConfigurationProperties properties, MetricsTraceLogger metricsTraceLogger) {
        this.enabled = properties.isEnabled();
        this.metricsTraceLogger = metricsTraceLogger;
        this.filter = DataPointFilter.createForAllowDenyLists((Set)properties.getAllowList(), (Set)properties.getDenyList());
    }

    public void dataPointsReceived(DataPointsReceivedEvent event) {
        if (this.enabled) {
            this.metricsTraceLogger.trace(event.getDataPoints(), "Metric received by PrometheusExporter");
            event.getDataPoints().stream().filter(this.filter).forEach(dataPoint -> {
                Tags tags = dataPoint.getTags();
                if (dataPoint.getUnit() != null) {
                    tags = tags.add("unit", dataPoint.getUnit());
                }
                long dataPointTime = dataPoint.getTime();
                Key key = new Key(dataPoint.getName(), tags);
                PrometheusExportableValue existingValue = (PrometheusExportableValue)this.store.getIfPresent((Object)key);
                if (existingValue == null || PrometheusExportableValue.access$200((PrometheusExportableValue)existingValue) < dataPointTime) {
                    if (dataPoint.getType() == DataPointType.DOUBLE) {
                        this.store.put((Object)key, (Object)new PrometheusExportableValue(dataPointTime, dataPoint.getDoubleValue()));
                    } else {
                        this.store.put((Object)key, (Object)new PrometheusExportableValue(dataPointTime, (double)dataPoint.getValue()));
                    }
                    this.metricsTraceLogger.trace(dataPoint, "Metric stored in PrometheusExporter");
                }
            });
        }
    }

    @Licensed
    public void printExport(HttpServletRequest request, HttpServletResponse response) {
        this.requestReceived = true;
        response.setContentType("text/plain; version=0.0.4; charset=utf-8");
        try (BufferedWriter writer = new BufferedWriter(response.getWriter());){
            if (this.checkIfPrometheusExportIsDisabled(response, writer)) {
                return;
            }
            PrometheusTokenPrinter printer = new PrometheusTokenPrinter((Appendable)writer);
            for (Map.Entry entry : this.store.asMap().entrySet()) {
                Key key = (Key)entry.getKey();
                PrometheusExportableValue value = (PrometheusExportableValue)entry.getValue();
                printer.printMetricName(Key.access$000((Key)key));
                printer.print('{');
                this.printTags(printer, Key.access$100((Key)key));
                printer.print("} ").print(Double.toString(value.getValue())).print(' ').print(String.valueOf(value.getTime())).print('\n');
                this.metricsTraceLogger.trace(Key.access$000((Key)key), Key.access$100((Key)key), PrometheusExportableValue.access$200((PrometheusExportableValue)value), PrometheusExportableValue.access$300((PrometheusExportableValue)value), "Metric exported to Prometheus");
            }
            writer.flush();
            if (response.getWriter().checkError()) {
                log.error("Failed to export metrics to Prometheus");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void printTags(PrometheusTokenPrinter printer, Tags tags) throws IOException {
        for (Tags.Tag tag : tags) {
            printer.printTagName(tag.getName()).print("=\"").printLabelValue(tag.getValue()).print("\",");
        }
    }

    private boolean checkIfPrometheusExportIsDisabled(HttpServletResponse response, BufferedWriter writer) throws IOException {
        if (!this.enabled) {
            String logMessage = "Prometheus exporter is disabled. It can be turned on by setting the system property " + EnvProperty.PROMETHEUS_EXPORTER_ENABLED + "=true";
            if (!this.loggedDisabledWarning) {
                log.warn(logMessage);
                this.loggedDisabledWarning = true;
            }
            response.setStatus(404);
            writer.append(logMessage);
            return true;
        }
        return false;
    }

    public boolean wasRequestReceived() {
        return this.requestReceived;
    }
}

