/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.prometheus;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.config.properties.PrometheusExporterConfigurationProperties;
import com.hazelcast.webmonitor.service.metrics.MetricsTraceLogger;
import com.hazelcast.webmonitor.service.prometheus.AuthenticatingPrometheusExporter;
import com.hazelcast.webmonitor.service.prometheus.DataPointReceiver;
import com.hazelcast.webmonitor.service.prometheus.PrometheusAuthDetailsStorage;
import com.hazelcast.webmonitor.service.prometheus.PrometheusExporter;
import com.hazelcast.webmonitor.service.prometheus.PrometheusExporterImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class PrometheusConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusConfig.class);
    private final PrometheusExporterConfigurationProperties properties;
    private final MetricsTraceLogger metricsTraceLogger;
    private PrometheusExporterImpl exporter;

    @Bean
    public PrometheusExporter prometheusExporter(PrometheusAuthDetailsStorage authDetailsStorage, AuditLogService auditLog) {
        PrometheusExporterImpl defaultImpl = this.prometheusExporterImpl();
        return authDetailsStorage.getPrometheusAuthDetails().map(authDetails -> new AuthenticatingPrometheusExporter(defaultImpl, authDetails, auditLog)).orElse((PrometheusExporter)defaultImpl);
    }

    PrometheusExporterImpl prometheusExporterImpl() {
        if (this.exporter == null) {
            this.exporter = new PrometheusExporterImpl(this.properties, this.metricsTraceLogger);
        }
        return this.exporter;
    }

    @Bean
    public DataPointReceiver prometheusDataPointReceiver() {
        return new DataPointReceiver(this.prometheusExporterImpl());
    }

    @ConstructorProperties(value={"properties", "metricsTraceLogger"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PrometheusConfig(PrometheusExporterConfigurationProperties properties, MetricsTraceLogger metricsTraceLogger) {
        this.properties = properties;
        this.metricsTraceLogger = metricsTraceLogger;
    }
}

