/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.prometheus;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.auditlog.Level;
import com.hazelcast.webmonitor.auditlog.impl.AuditableEvent;
import com.hazelcast.webmonitor.service.prometheus.PrometheusAuthDetails;
import com.hazelcast.webmonitor.service.prometheus.PrometheusExporter;
import com.hazelcast.webmonitor.service.prometheus.PrometheusExporterImpl;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class AuthenticatingPrometheusExporter
implements PrometheusExporter {
    private static final String EXPECTED_AUTH_HEADER_PREFIX = "Basic ";
    private final PrometheusExporterImpl delegate;
    private final String expectedAuthHeaderValue;
    private final AuditLogService auditLog;

    public AuthenticatingPrometheusExporter(PrometheusExporterImpl delegate, PrometheusAuthDetails expectedAuthDetails, AuditLogService auditLog) {
        this.delegate = delegate;
        this.expectedAuthHeaderValue = EXPECTED_AUTH_HEADER_PREFIX + expectedAuthDetails.toBase64();
        this.auditLog = auditLog;
    }

    private void logWarning(String message) {
        this.auditLog.log(AuditableEvent.builder().typeId("MC-2010 [Prometheus Auth]").level(Level.WARN).message(message).build());
    }

    public void printExport(HttpServletRequest request, HttpServletResponse response) {
        try {
            String authHeader = request.getHeader("Authorization");
            if (authHeader == null) {
                response.sendError(HttpStatus.UNAUTHORIZED.value());
                this.logWarning("missing Authorization header");
                return;
            }
            if (!authHeader.startsWith(EXPECTED_AUTH_HEADER_PREFIX)) {
                response.sendError(HttpStatus.UNAUTHORIZED.value());
                this.logWarning("incorrect authorization scheme in Authorization header. Supported authorization scheme is: Basic");
                return;
            }
            if (!this.expectedAuthHeaderValue.equals(authHeader)) {
                response.sendError(HttpStatus.UNAUTHORIZED.value());
                this.logWarning("incorrect username or password sent in Authorization header");
                return;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.delegate.printExport(request, response);
    }

    public boolean wasRequestReceived() {
        return this.delegate.wasRequestReceived();
    }
}

