/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.metrics;

import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Tags;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public class MetricsTraceLogger {
    private final MetricsConfigurationProperties metricsConfigurationProperties;
    private final Logger logger;

    public void trace(List<MetricDataPoint> metricDataPoints, String message) {
        if (!this.metricsConfigurationProperties.getTraceMetrics().isEmpty()) {
            metricDataPoints.forEach(metricDataPoint -> this.trace(metricDataPoint, message));
        }
    }

    public void trace(MetricDataPoint metricDataPoint, String message) {
        this.trace(metricDataPoint.getName(), metricDataPoint.getTags(), metricDataPoint.getTime(), (double)metricDataPoint.getValue(), message);
    }

    public void trace(String metric, Tags tags, long metricTime, double metricValue, String message) {
        if (this.metricsConfigurationProperties.getTraceMetrics().contains(metric)) {
            this.logger.trace("{} for metric={}, cluster={}, member={}, metricTime={}, value={}", new Object[]{message, metric, this.getCluster(tags), this.getMember(tags), metricTime, metricValue});
        }
    }

    private String getMember(Tags tags) {
        return tags.getTag("mc:member").map(Tags.Tag::getValue).orElse("");
    }

    private String getCluster(Tags tags) {
        return tags.getTag("mc:cluster").map(Tags.Tag::getValue).orElse("");
    }

    @ConstructorProperties(value={"metricsConfigurationProperties", "logger"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricsTraceLogger(MetricsConfigurationProperties metricsConfigurationProperties, Logger logger) {
        this.metricsConfigurationProperties = metricsConfigurationProperties;
        this.logger = logger;
    }
}

