/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.OperationServiceStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.OperationServiceMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class OperationServiceMXBeanImpl
implements OperationServiceMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Services";
    public static final String SERVICE_NAME = "OperationService";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String member;
    private volatile OperationServiceStatsDTO stats;

    public OperationServiceMXBeanImpl(ClusteredStatsService statsService, String cluster, String member) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.member = member;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getOperationServiceStats(this.cluster, this.member);
    }

    public String getName() {
        return this.member;
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.cluster, (String)TYPE_NAME, (String)SERVICE_NAME, (String)this.member);
    }

    public int getResponseQueueSize() {
        return MXBeanHelper.safeGet((Object)this.stats, OperationServiceStatsDTO::getResponseQueueSize);
    }

    public int getOperationExecutorQueueSize() {
        return MXBeanHelper.safeGet((Object)this.stats, OperationServiceStatsDTO::getOperationExecutorQueueSize);
    }

    public int getRunningOperationsCount() {
        return MXBeanHelper.safeGet((Object)this.stats, OperationServiceStatsDTO::getRunningOperationsCount);
    }

    public int getRemoteOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, OperationServiceStatsDTO::getRemoteOperationCount);
    }

    public long getExecutedOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, OperationServiceStatsDTO::getExecutedOperationCount);
    }

    public long getOperationThreadCount() {
        return MXBeanHelper.safeGet((Object)this.stats, OperationServiceStatsDTO::getOperationThreadCount);
    }
}

