/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.webmonitor.EnvProperty;
import com.hazelcast.webmonitor.config.properties.JMXConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.SSLProperties;
import com.hazelcast.webmonitor.service.ClientNearCacheStatsManager;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusteredJetStatsProvider;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.EnterpriseServiceProvider;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.impl.ClusterMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.JMXService;
import com.hazelcast.webmonitor.service.jmx.impl.JMXServiceImpl;
import com.hazelcast.webmonitor.service.jmx.impl.JmxSslRMIClientSocketFactory;
import com.hazelcast.webmonitor.service.jmx.impl.ManagementCenterMXBeanImpl;
import com.hazelcast.webmonitor.ssl.SSLContextFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"hazelcast.mc.jmx.enabled"})
public class JMXServiceImpl
implements JMXService,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JMXServiceImpl.class);
    private static final int SCHEDULER_DELAY_SECONDS = 5;
    private static final Feature FEATURE = Feature.CLUSTERED_JMX;
    private final Map<String, ClusterMXBeanImpl> clusters = new ConcurrentHashMap();
    private final EnterpriseServiceProvider enterpriseServiceProvider;
    private final ClusteredStatsService clusteredStatsService;
    private final ClientNearCacheStatsManager clientNearCacheStatsManager;
    private final ClusterManager clusterManager;
    private final ClusteredJetStatsProvider clusteredJetStatsProvider;
    private final Registry registry;
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final CompletableFuture<JMXConnectorServer> jmxConnectorServer;
    private final JMXConfigurationProperties jmxProperties;
    private final ManagementCenterMXBeanImpl managementCenterMXBean;

    @Autowired
    public JMXServiceImpl(EnterpriseServiceProvider enterpriseServiceProvider, ClusteredStatsService clusteredStatsService, ClientNearCacheStatsManager clientNearCacheStatsManager, LicenseManager licenseManager, ClusterManager clusterManager, ClusteredJetStatsProvider clusteredJetStatsProvider, JMXConfigurationProperties jmxProperties) {
        this.enterpriseServiceProvider = enterpriseServiceProvider;
        this.clusteredStatsService = clusteredStatsService;
        this.clientNearCacheStatsManager = clientNearCacheStatsManager;
        this.jmxProperties = jmxProperties;
        this.registry = this.createRegistry();
        this.jmxConnectorServer = this.start();
        this.clusterManager = clusterManager;
        this.clusteredJetStatsProvider = clusteredJetStatsProvider;
        this.managementCenterMXBean = new ManagementCenterMXBeanImpl(licenseManager, enterpriseServiceProvider);
    }

    private Optional<JMXConnectorServer> getConnectorServer() {
        try {
            if (this.jmxConnectorServer == null) {
                return Optional.empty();
            }
            return Optional.ofNullable((JMXConnectorServer)this.jmxConnectorServer.get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.unregisterManagementCenterMBean();
        this.unregisterClusterMBeans();
        this.stopConnectorServer();
        this.destroyRMIRegistry();
    }

    private void destroyRMIRegistry() {
        try {
            if (this.registry != null) {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
        }
        catch (Exception e) {
            log.warn("Failed to destroy RMI registry.", (Throwable)e);
        }
    }

    private void stopConnectorServer() {
        try {
            Optional connectorServer = this.getConnectorServer();
            if (connectorServer.isPresent()) {
                ((JMXConnectorServer)connectorServer.get()).stop();
            }
        }
        catch (Exception e) {
            log.warn("Failed to stop JMX connector server.", (Throwable)e);
        }
    }

    private void unregisterManagementCenterMBean() {
        try {
            this.unregister(ManagementCenterMXBeanImpl.getObjectName());
        }
        catch (Exception e) {
            log.warn("Failed to unregister Management Center MBean.", (Throwable)e);
        }
    }

    private void unregisterClusterMBeans() {
        for (ClusterMXBeanImpl clusterMXBean : this.clusters.values()) {
            try {
                clusterMXBean.unregister();
            }
            catch (Exception e) {
                log.warn("Failed to unregister cluster MBean for {}.", (Object)clusterMXBean.getName(), (Object)e);
            }
        }
    }

    private Registry createRegistry() {
        try {
            return LocateRegistry.createRegistry(this.jmxProperties.getPort());
        }
        catch (RemoteException e) {
            log.warn("Exception while creating registry for JMX Service: " + e.getMessage(), (Throwable)e);
            log.warn("JMX service did not start!");
            return null;
        }
    }

    public JMXServiceURL getServiceURL() throws MalformedURLException {
        String hostname = Optional.ofNullable(this.jmxProperties.getHost()).orElseGet(() -> this.getHostNameOrThrow());
        return new JMXServiceURL(String.format("service:jmx:rmi://%s:%d/jndi/rmi://%s:%d/jmxrmi", hostname, this.jmxProperties.getRmi().getPort(), hostname, this.jmxProperties.getPort()));
    }

    private String getHostNameOrThrow() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(EnvProperty.JMX_HOST_NAME + " property was not set and hostname can't be resolved automatically", e);
        }
    }

    private Map<String, Object> constructConnectorServerEnv() throws Exception {
        JMXConfigurationProperties.JmxSSLProperties jmxSSLProperties = this.jmxProperties.getSsl();
        if (jmxSSLProperties.isEnabled()) {
            HashMap<String, Object> env = new HashMap<String, Object>();
            log.info("SSL is enabled for JMX.");
            env.put("jmx.remote.rmi.client.socket.factory", new JmxSslRMIClientSocketFactory());
            env.put("jmx.remote.rmi.server.socket.factory", new SslRMIServerSocketFactory(SSLContextFactory.createSSLContext((SSLProperties)jmxSSLProperties), null, null, jmxSSLProperties.isMutualAuthentication()));
            return env;
        }
        return Collections.emptyMap();
    }

    private JMXConnectorServer initJMXConnectorServer() {
        JMXConnectorServer cs = null;
        log.info("Starting Management Center JMX Service on port: {}", (Object)this.jmxProperties.getPort());
        try {
            cs = JMXConnectorServerFactory.newJMXConnectorServer(this.getServiceURL(), this.constructConnectorServerEnv(), this.server);
            cs.start();
            this.server.registerMBean(this.managementCenterMXBean, ManagementCenterMXBeanImpl.getObjectName());
            this.enterpriseServiceProvider.getScheduledExecutorService().scheduleWithFixedDelay((Runnable)new JMXRunner(this, (JMXService)this, null), 5L, 5L, TimeUnit.SECONDS);
            return cs;
        }
        catch (Exception e) {
            log.warn("Exception while starting JMX Service: " + e.getMessage(), (Throwable)e);
            if (cs == null || !cs.isActive()) {
                log.warn("JMX service did not start!");
            }
            return null;
        }
    }

    private CompletableFuture<JMXConnectorServer> start() {
        if (this.registry == null) {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> this.initJMXConnectorServer());
    }

    public void register(ObjectName name, BaseManagementBean bean) {
        try {
            if (!this.server.isRegistered(name)) {
                this.server.registerMBean(bean, name);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void unregister(ObjectName name) {
        try {
            if (this.server.isRegistered(name)) {
                this.server.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static String quote(String text) {
        return Pattern.compile("[:\",=*?]").matcher(text).find() ? ObjectName.quote(text) : text;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void waitForStart() {
        this.getConnectorServer();
    }

    static /* synthetic */ Feature access$100() {
        return FEATURE;
    }

    static /* synthetic */ EnterpriseServiceProvider access$200(JMXServiceImpl x0) {
        return x0.enterpriseServiceProvider;
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static /* synthetic */ Map access$400(JMXServiceImpl x0) {
        return x0.clusters;
    }

    static /* synthetic */ ClusteredJetStatsProvider access$500(JMXServiceImpl x0) {
        return x0.clusteredJetStatsProvider;
    }

    static /* synthetic */ ClientNearCacheStatsManager access$600(JMXServiceImpl x0) {
        return x0.clientNearCacheStatsManager;
    }

    static /* synthetic */ ClusteredStatsService access$700(JMXServiceImpl x0) {
        return x0.clusteredStatsService;
    }

    static /* synthetic */ ClusterManager access$800(JMXServiceImpl x0) {
        return x0.clusterManager;
    }
}

