/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.HzExecutorNames;
import com.hazelcast.webmonitor.model.hz.req.state.LicenseDTO;
import com.hazelcast.webmonitor.model.hz.req.state.LocalWanStats;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.service.ClientNearCacheStatsManager;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusteredJetStatsProvider;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.Utils;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.ClusterMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.CacheMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.ClientMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.ClientStatMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.ConnectionManagerMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.EventServiceMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.ExecutorMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.ExportedJobSnapshotMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.FlakeIdGeneratorMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.JMXService;
import com.hazelcast.webmonitor.service.jmx.impl.JobMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.ManagedExecutorMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.MapMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.MemberMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.MultiMapMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.NearCacheStatsMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.OperationServiceMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.PNCounterMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.PartitionServiceMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.ProxyServiceMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.QueueMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.ReliableTopicMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.ReplicatedMapMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.TopicMXBeanImpl;
import com.hazelcast.webmonitor.service.jmx.impl.WanRepMXBeanImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.management.ObjectName;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClusterMXBeanImpl
implements ClusterMXBean,
BaseManagementBean {
    private final JMXService jmxService;
    private final ClusteredJetStatsProvider clusteredJetStatsProvider;
    private final ClusterManager clusterManager;
    private final ClientNearCacheStatsManager clientNearCacheStatsManager;
    private final ClusteredStatsService clusteredStatsService;
    private final String cluster;
    private final Set<MapMXBeanImpl> mapBeans = ConcurrentHashMap.newKeySet();
    private final Set<CacheMXBeanImpl> cacheBeans = ConcurrentHashMap.newKeySet();
    private final Set<QueueMXBeanImpl> queueBeans = ConcurrentHashMap.newKeySet();
    private final Set<TopicMXBeanImpl> topicBeans = ConcurrentHashMap.newKeySet();
    private final Set<ReliableTopicMXBeanImpl> reliableTopicBeans = ConcurrentHashMap.newKeySet();
    private final Set<MultiMapMXBeanImpl> multimapBeans = ConcurrentHashMap.newKeySet();
    private final Set<ReplicatedMapMXBeanImpl> replicatedmapBeans = ConcurrentHashMap.newKeySet();
    private final Set<ExecutorMXBeanImpl> executorBeans = ConcurrentHashMap.newKeySet();
    private final Set<WanRepMXBeanImpl> wanRepBeans = ConcurrentHashMap.newKeySet();
    private final Set<MemberMXBeanImpl> memberBeans = ConcurrentHashMap.newKeySet();
    private final Set<ClientMXBeanImpl> clientBeans = ConcurrentHashMap.newKeySet();
    private final Set<EventServiceMXBeanImpl> eventServiceBeans = ConcurrentHashMap.newKeySet();
    private final Set<OperationServiceMXBeanImpl> operationServiceBeans = ConcurrentHashMap.newKeySet();
    private final Set<ConnectionManagerMXBeanImpl> connectionManagerBeans = ConcurrentHashMap.newKeySet();
    private final Set<ProxyServiceMXBeanImpl> proxyServiceBeans = ConcurrentHashMap.newKeySet();
    private final Set<PartitionServiceMXBeanImpl> partitionServiceBeans = ConcurrentHashMap.newKeySet();
    private final Set<ManagedExecutorMXBeanImpl> managedExecutorBeans = ConcurrentHashMap.newKeySet();
    private final Set<ClientStatMXBeanImpl> clientStatBeans = ConcurrentHashMap.newKeySet();
    private final Set<PNCounterMXBeanImpl> counterStatBeans = ConcurrentHashMap.newKeySet();
    private final Set<FlakeIdGeneratorMXBeanImpl> flakeIdGeneratorStatBeans = ConcurrentHashMap.newKeySet();
    private final Set<JobMXBeanImpl> jobBeans = ConcurrentHashMap.newKeySet();
    private final Set<ExportedJobSnapshotMXBeanImpl> exportedJobSnapshotBeans = ConcurrentHashMap.newKeySet();
    private final Set<NearCacheStatsMXBeanImpl> nearCacheStatsBeans = ConcurrentHashMap.newKeySet();
    private volatile String masterAddress;
    private volatile long licenseExpirationTime;

    public ClusterMXBeanImpl(JMXService jmxService, ClusteredJetStatsProvider clusteredJetStatsProvider, ClientNearCacheStatsManager clientNearCacheStatsManager, ClusteredStatsService clusteredStatsService, String name, ClusterManager clusterManager) {
        this.jmxService = jmxService;
        this.clusteredJetStatsProvider = clusteredJetStatsProvider;
        this.clientNearCacheStatsManager = clientNearCacheStatsManager;
        this.clusteredStatsService = clusteredStatsService;
        this.cluster = name;
        this.clusterManager = clusterManager;
        jmxService.register(this.getObjectName(), (BaseManagementBean)this);
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        String master = Utils.getMaster((AllState)state);
        if (master != null) {
            MemberState memberState = (MemberState)state.getMemberStates().get(master);
            this.masterAddress = memberState.getAddress();
            LicenseDTO licenseDTO = memberState.getNodeState().getLicenseDTO();
            this.licenseExpirationTime = licenseDTO != null ? licenseDTO.getExpirationTime() : -1L;
        }
        Set members = StreamSupport.stream(state.getTimedMemberStates().keys().spliterator(), false).collect(Collectors.toSet());
        this.updateBeans(state, (Set)state.getInstanceNames(InstanceType.MAP), this.mapBeans, name -> new MapMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, this.getNearCacheStatNames(state), this.nearCacheStatsBeans, name -> {
            String[] parts = name.split("#");
            return new NearCacheStatsMXBeanImpl(this.clusteredStatsService, this.cluster, parts[0], parts[2], InstanceType.valueOf((String)parts[1]));
        });
        this.updateBeans(state, (Set)state.getInstanceNames(InstanceType.CACHE), this.cacheBeans, name -> new CacheMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, (Set)state.getInstanceNames(InstanceType.QUEUE), this.queueBeans, name -> new QueueMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, (Set)state.getInstanceNames(InstanceType.TOPIC), this.topicBeans, name -> new TopicMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, (Set)state.getInstanceNames(InstanceType.RELIABLE_TOPIC), this.reliableTopicBeans, name -> new ReliableTopicMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, (Set)state.getInstanceNames(InstanceType.MULTIMAP), this.multimapBeans, name -> new MultiMapMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, (Set)state.getInstanceNames(InstanceType.REPLICATED_MAP), this.replicatedmapBeans, name -> new ReplicatedMapMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, (Set)state.getInstanceNames(InstanceType.EXECUTOR_SERVICE), this.executorBeans, name -> new ExecutorMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, ClusterMXBeanImpl.getWanPublisherIds((AllState)state), this.wanRepBeans, name -> new WanRepMXBeanImpl(this.clusteredStatsService, this.cluster, (String)name.element1, (String)name.element2));
        this.updateBeans(state, (Set)state.getInstanceNames(InstanceType.COUNTER), this.counterStatBeans, name -> new PNCounterMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, (Set)state.getInstanceNames(InstanceType.FLAKE_ID_GENERATOR), this.flakeIdGeneratorStatBeans, name -> new FlakeIdGeneratorMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, state.getClientAddresses(), this.clientBeans, name -> new ClientMXBeanImpl(this.cluster, name));
        this.updateBeans(state, members, this.memberBeans, name -> new MemberMXBeanImpl(this.clusteredStatsService, this.cluster, name));
        this.updateBeans(state, members, this.eventServiceBeans, member -> new EventServiceMXBeanImpl(this.clusteredStatsService, this.cluster, member));
        this.updateBeans(state, members, this.operationServiceBeans, member -> new OperationServiceMXBeanImpl(this.clusteredStatsService, this.cluster, member));
        this.updateBeans(state, members, this.connectionManagerBeans, member -> new ConnectionManagerMXBeanImpl(this.clusteredStatsService, this.cluster, member));
        this.updateBeans(state, members, this.proxyServiceBeans, member -> new ProxyServiceMXBeanImpl(this.clusteredStatsService, this.cluster, member));
        this.updateBeans(state, members, this.partitionServiceBeans, member -> new PartitionServiceMXBeanImpl(this.clusteredStatsService, this.cluster, member));
        this.updateBeans(state, ClusterMXBeanImpl.getExecutorNames(members), this.managedExecutorBeans, compositeKey -> {
            String[] key = compositeKey.split("###");
            return new ManagedExecutorMXBeanImpl(this.clusteredStatsService, this.cluster, key[0], key[1]);
        });
        this.updateBeans(state, state.getClientAttributes().keySet(), this.clientStatBeans, clientUuid -> new ClientStatMXBeanImpl(this.clusteredStatsService, this.cluster, clientUuid));
        if (this.clusterManager.isJetEnabled(this.cluster)) {
            Map jobs = this.clusteredJetStatsProvider.getJobs(this.cluster);
            Map snapshots = this.clusteredJetStatsProvider.getSnapshots(this.cluster);
            this.updateBeans(state, jobs.keySet(), this.jobBeans, id -> new JobMXBeanImpl(this.clusteredJetStatsProvider, this.cluster, id));
            this.updateBeans(state, snapshots.keySet(), this.exportedJobSnapshotBeans, name -> new ExportedJobSnapshotMXBeanImpl(this.clusteredJetStatsProvider, this.cluster, name));
        }
    }

    private Set<String> getNearCacheStatNames(AllState state) {
        HashSet<String> names = new HashSet<String>();
        for (String uuid : state.getClientAttributes().keySet()) {
            names.addAll(this.beanNamesForType(uuid, InstanceType.MAP));
            names.addAll(this.beanNamesForType(uuid, InstanceType.CACHE));
        }
        return names;
    }

    private Set<String> beanNamesForType(String uuid, InstanceType type) {
        HashSet<String> names = new HashSet<String>();
        for (String name : this.clientNearCacheStatsManager.getDataStructuresByClient(this.cluster, uuid, type)) {
            names.add(NearCacheStatsMXBeanImpl.getName((String)uuid, (InstanceType)type, (String)name));
        }
        return names;
    }

    private static Set<String> getExecutorNames(Set<String> members) {
        HashSet<String> names = new HashSet<String>();
        for (String executor : HzExecutorNames.EXECUTOR_NAMES) {
            for (String member : members) {
                names.add(member + "###" + executor);
            }
        }
        return names;
    }

    private static Set<BiTuple<String, String>> getWanPublisherIds(AllState state) {
        HashSet<BiTuple<String, String>> names = new HashSet<BiTuple<String, String>>();
        for (String wanConfigName : state.getInstanceNames(InstanceType.WAN_REPLICATION)) {
            for (MemberState memberState : state.getMemberStates()) {
                LocalWanStats wanStats = memberState.getLocalWanStats(wanConfigName);
                if (wanStats == null) continue;
                for (Map.Entry statsEntry : wanStats.getLocalWanPublisherStats().entrySet()) {
                    String publisherID = (String)statsEntry.getKey();
                    names.add((BiTuple<String, String>)BiTuple.of((Object)wanConfigName, (Object)publisherID));
                }
            }
        }
        return names;
    }

    private <B extends BaseManagementBean, N> void updateBeans(AllState state, Set<N> expectedNames, Set<B> beans, Function<N, B> beanCreator) {
        Iterator<B> iter = beans.iterator();
        HashSet<N> newNames = new HashSet<N>(expectedNames);
        while (iter.hasNext()) {
            BaseManagementBean bean = (BaseManagementBean)iter.next();
            if (newNames.remove(bean.getName())) {
                bean.updateFrom(state);
                continue;
            }
            this.jmxService.unregister(bean.getObjectName());
            iter.remove();
        }
        for (Object name : newNames) {
            BaseManagementBean bean = (BaseManagementBean)beanCreator.apply(name);
            bean.updateFrom(state);
            this.jmxService.register(bean.getObjectName(), bean);
            beans.add(bean);
        }
    }

    public String getMasterAddress() {
        return this.masterAddress;
    }

    public long getLicenseExpirationTime() {
        return this.licenseExpirationTime;
    }

    public boolean isStreamingSupported() {
        return this.clusterManager.isJetEnabled(this.cluster);
    }

    public void unregister() {
        this.jmxService.unregister(this.getObjectName());
        this.unregisterAll((Collection)this.mapBeans);
        this.unregisterAll((Collection)this.nearCacheStatsBeans);
        this.unregisterAll((Collection)this.cacheBeans);
        this.unregisterAll((Collection)this.queueBeans);
        this.unregisterAll((Collection)this.topicBeans);
        this.unregisterAll((Collection)this.reliableTopicBeans);
        this.unregisterAll((Collection)this.multimapBeans);
        this.unregisterAll((Collection)this.replicatedmapBeans);
        this.unregisterAll((Collection)this.executorBeans);
        this.unregisterAll((Collection)this.wanRepBeans);
        this.unregisterAll((Collection)this.counterStatBeans);
        this.unregisterAll((Collection)this.flakeIdGeneratorStatBeans);
        this.unregisterAll((Collection)this.memberBeans);
        this.unregisterAll((Collection)this.clientBeans);
        this.unregisterAll((Collection)this.eventServiceBeans);
        this.unregisterAll((Collection)this.operationServiceBeans);
        this.unregisterAll((Collection)this.connectionManagerBeans);
        this.unregisterAll((Collection)this.proxyServiceBeans);
        this.unregisterAll((Collection)this.partitionServiceBeans);
        this.unregisterAll((Collection)this.managedExecutorBeans);
        this.unregisterAll((Collection)this.clientStatBeans);
    }

    private <T extends BaseManagementBean> void unregisterAll(Collection<T> beans) {
        for (BaseManagementBean bean : beans) {
            this.jmxService.unregister(bean.getObjectName());
        }
        beans.clear();
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.cluster, (String)this.cluster);
    }

    public String getName() {
        return this.cluster;
    }
}

