/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jet;

import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.webmonitor.controller.dto.jet.DagDTO;
import com.hazelcast.webmonitor.controller.dto.jet.EdgeTransceptionInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.ProcessorInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.VertexInfoDTO;
import com.hazelcast.webmonitor.metrics.jet.JetClusterMetricsStore;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpression;
import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpressions;
import com.hazelcast.webmonitor.metrics.jet.tsdb.TimeSeries;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.jet.BaseJetManager;
import com.hazelcast.webmonitor.service.jet.JetMetricsService;
import com.hazelcast.webmonitor.service.jet.VertexManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
class VertexManager
extends BaseJetManager {
    private static final int PERCENT_MULTIPLIER = 100;
    static final int NOT_AVAILABLE = -1;
    static final int IDLE_PROCESSOR = -2;

    VertexManager(MCClientManager clientManager, JetMetricsService jetMetricsService, Clock clock) {
        super(clientManager, jetMetricsService, clock);
    }

    VertexInfoDTO getVertexDetails(String cluster, String jobId, String vertexName) {
        long skew;
        VertexIdentifier vertex = new VertexIdentifier(new BaseJetManager.JobIdentifier(cluster, jobId), vertexName);
        BaseJetManager.JobIdentifier jobIdentifier = vertex.job;
        Job from = this.getJob(jobIdentifier);
        JobStatus jobStatus = from.getStatus();
        String lastExecutionId = this.getLastExecutionId(jobIdentifier);
        VertexInfoDTO.VertexInfoDTOBuilder info = VertexInfoDTO.builder();
        info.id(vertex.id);
        info.jobId(jobIdentifier.idString);
        info.lastExecutionId(lastExecutionId);
        long end = this.clock.currentTimeMillis();
        ItemsTransceived in = this.getItemsTransceived(vertex, jobStatus, lastExecutionId, end, "receivedCount");
        info.totalIn(in.total);
        info.lastMinIn(in.lastMin);
        ItemsTransceived outMetrics = this.getItemsTransceived(vertex, jobStatus, lastExecutionId, end, "emittedCount");
        info.totalOut(outMetrics.total);
        info.lastMinOut(outMetrics.lastMin);
        JobRepository jobRepository = new JobRepository(this.clientFor(cluster).getHzClient());
        JobRecord jobRecord = jobRepository.getJobRecord(jobIdentifier.id);
        if (jobRecord != null) {
            DagDTO dag = this.getDag(jobIdentifier, lastExecutionId, jobRecord);
            dag.getVertices().stream().filter(v -> vertexName.equals(v.getName())).findFirst().ifPresent(v -> info.parallelism(v.getParallelism()).globalParallelism(v.getGlobalParallelism()));
        }
        List edges = this.getEdges(jobRecord);
        info.incoming(this.getIncoming(vertex, lastExecutionId, edges));
        info.outgoing(this.getOutgoing(vertex, lastExecutionId, edges));
        info.processors(this.getProcessors(vertex, lastExecutionId));
        List lastForwardedWmLatencies = this.getLastForwardedWmLatencies(vertex, lastExecutionId);
        long maxLatencyToRealTime = this.getMaxLatency(lastForwardedWmLatencies);
        if (maxLatencyToRealTime == -1L) {
            skew = -1L;
        } else if (maxLatencyToRealTime == Long.MAX_VALUE) {
            skew = -1L;
            maxLatencyToRealTime = -1L;
        } else {
            long minLatency = this.getMinLatency(lastForwardedWmLatencies);
            skew = Math.max(-1L, maxLatencyToRealTime - minLatency);
        }
        info.maxLatencyToRealTime(maxLatencyToRealTime);
        info.skew(skew);
        return info.build();
    }

    private Map<String, EdgeTransceptionInfoDTO> getOutgoing(VertexIdentifier vertex, String lastExecutionId, List<Edge> edges) {
        return this.getTransceptionInfoForEdges(vertex, lastExecutionId, edges, "emittedCount");
    }

    private Map<String, EdgeTransceptionInfoDTO> getIncoming(VertexIdentifier vertex, String lastExecutionId, List<Edge> edges) {
        return this.getTransceptionInfoForEdges(vertex, lastExecutionId, edges, "receivedCount");
    }

    private Map<String, EdgeTransceptionInfoDTO> getTransceptionInfoForEdges(VertexIdentifier vertex, String lastExecutionId, List<Edge> edges, String metric) {
        if (lastExecutionId == null) {
            return Collections.emptyMap();
        }
        BaseJetManager.JobIdentifier job = vertex.job;
        JetClusterMetricsStore store = this.storeFor(job);
        Predicate<EdgeTransceptionInfoDTO> edgeTransceptionInfoFilter = outEdgeInfo -> edges.stream().anyMatch(e -> e.fromOrdinal == (long)outEdgeInfo.getOrdinal() && e.sourceVertex.equals(outEdgeInfo.getVertex()));
        Collector collector = Collectors.toMap(edgeInfo -> edges.stream().filter(e -> e.fromOrdinal == (long)edgeInfo.getOrdinal() && e.sourceVertex.equals(edgeInfo.getVertex())).findFirst().map(e -> e.targetVertex).orElse(null), Function.identity(), VertexManager::mergeEdgeTransceptionInfos);
        return store.query(metric, (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)job.idString), TagExpressions.tagEquals((String)"vertex", (String)vertex.id), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagNotEquals((String)"ordinal", (String)"snapshot")})).map(ts -> (String)ts.tags().get("ordinal")).distinct().map(ordinal -> this.getTransceptionInfoByOrdinal(vertex, lastExecutionId, Integer.parseInt(ordinal), metric)).filter(edgeTransceptionInfoFilter).collect(collector);
    }

    private static EdgeTransceptionInfoDTO mergeEdgeTransceptionInfos(EdgeTransceptionInfoDTO r1, EdgeTransceptionInfoDTO r2) {
        return new EdgeTransceptionInfoDTO(r1.getVertex(), r1.getOrdinal(), r1.getLastMin() + r2.getLastMin(), r1.getTotal() + r2.getTotal());
    }

    private EdgeTransceptionInfoDTO getTransceptionInfoByOrdinal(VertexIdentifier vertexIdentifier, String lastExecutionId, int ordinal, String metric) {
        String vertex = vertexIdentifier.id;
        long end = this.clock.currentTimeMillis();
        JetClusterMetricsStore store = this.storeFor(vertexIdentifier.job);
        List emitted = store.query(metric, (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)vertexIdentifier.job.idString), TagExpressions.tagEquals((String)"vertex", (String)vertex), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagEquals((String)"ordinal", (String)String.valueOf(ordinal))})).collect(Collectors.toList());
        long total = emitted.stream().mapToLong(TimeSeries::queryLast).sum();
        long lastMin = emitted.stream().mapToLong(TimeSeries::getLatestTime).max().orElse(0L) < end - 60000L ? 0L : total - emitted.stream().mapToLong(ts -> ts.query(end - 60000L, 0L)).sum();
        return new EdgeTransceptionInfoDTO(vertex, ordinal, total, lastMin);
    }

    private ItemsTransceived getItemsTransceived(VertexIdentifier vertex, JobStatus jobStatus, String lastExecutionId, long end, String metricName) {
        List received = this.getMetric(vertex, lastExecutionId, metricName);
        long totalIn = received.stream().mapToLong(TimeSeries::queryLast).sum();
        long lastMinIn = 0L;
        if (jobStatus != JobStatus.SUSPENDED || received.stream().mapToLong(TimeSeries::getLatestTime).max().orElse(0L) >= end - 60000L) {
            lastMinIn = totalIn - received.stream().mapToLong(ts -> ts.query(end - 60000L, 0L)).sum();
        }
        return new ItemsTransceived(totalIn, lastMinIn);
    }

    private List<TimeSeries> getMetric(VertexIdentifier vertex, String lastExecutionId, String metric) {
        if (lastExecutionId == null) {
            return Collections.emptyList();
        }
        BaseJetManager.JobIdentifier job = vertex.job;
        JetClusterMetricsStore store = this.storeFor(job);
        return store.query(metric, (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)job.idString), TagExpressions.tagEquals((String)"vertex", (String)vertex.id), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagNotEquals((String)"ordinal", (String)"snapshot")})).collect(Collectors.toList());
    }

    private long getMinLatency(List<Long> lastForwardedWmLatencies) {
        return lastForwardedWmLatencies.stream().mapToLong(Long::longValue).filter(val -> val >= 0L).min().orElse(-1L);
    }

    private long getMaxLatency(List<Long> lastForwardedWmLatencies) {
        return lastForwardedWmLatencies.stream().mapToLong(Long::longValue).filter(val -> val >= 0L).max().orElse(-1L);
    }

    private List<Long> getLastForwardedWmLatencies(VertexIdentifier vertex, String lastExecutionId) {
        if (lastExecutionId == null) {
            return Collections.emptyList();
        }
        JetClusterMetricsStore store = this.storeFor(vertex.job);
        return store.query("lastForwardedWmLatency", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)vertex.job.idString), TagExpressions.tagEquals((String)"vertex", (String)vertex.id), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagNull((String)"ordinal"), TagExpressions.tagNotEquals((String)"ordinal", (String)"snapshot")})).map(TimeSeries::queryLast).collect(Collectors.toList());
    }

    private Map<Integer, ProcessorInfoDTO> getProcessors(VertexIdentifier vertex, String lastExecutionId) {
        if (lastExecutionId == null) {
            return Collections.emptyMap();
        }
        JetClusterMetricsStore store = this.storeFor(vertex.job);
        String jobId = vertex.job.idString;
        return store.query("queuesSize", (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)jobId), TagExpressions.tagEquals((String)"vertex", (String)vertex.id), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagNotEquals((String)"ordinal", (String)"snapshot")})).map(ts -> (String)ts.tags().get("proc")).distinct().map(processor -> this.toProcessorInfo(vertex, lastExecutionId, Integer.parseInt(processor))).collect(Collectors.toMap(ProcessorInfoDTO::getProcessorId, Function.identity()));
    }

    private List<Edge> getEdges(JobRecord jobRecord) {
        if (jobRecord == null) {
            return Collections.emptyList();
        }
        JsonObject dag = Json.parse((String)jobRecord.getDagJson()).asObject();
        JsonArray edges = dag.get("edges").asArray();
        ArrayList<Edge> edgesList = new ArrayList<Edge>();
        for (JsonValue edge : edges) {
            JsonObject edgeObject = edge.asObject();
            Edge e = new Edge(edgeObject.getString("from", ""), edgeObject.getLong("fromOrdinal", -1L), edgeObject.getString("to", ""), (long)edgeObject.getInt("toOrdinal", -1));
            edgesList.add(e);
        }
        return edgesList;
    }

    public ProcessorInfoDTO toProcessorInfo(VertexIdentifier vertex, String lastExecutionId, int processorId) {
        String jobId = vertex.job.idString;
        JetClusterMetricsStore store = this.storeFor(vertex.job);
        long wmLatency = this.getProcessorMetric(jobId, vertex.id, lastExecutionId, processorId, store, "lastForwardedWmLatency");
        long lastForwardedWmLatency = wmLatency == Long.MAX_VALUE ? -1L : (wmLatency == Long.MIN_VALUE ? -2L : wmLatency);
        long queueSize = this.getProcessorMetric(jobId, vertex.id, lastExecutionId, processorId, store, "queuesSize");
        long queueCapacity = this.getProcessorMetric(jobId, vertex.id, lastExecutionId, processorId, store, "queuesCapacity");
        DecimalFormat df = new DecimalFormat("#0.00");
        return ProcessorInfoDTO.builder().vertex(vertex.id).processorId(processorId).queueSize(queueSize).queueCapacity(queueCapacity).emittedCount(this.getProcessorMetricSum(jobId, vertex.id, lastExecutionId, processorId, store, "emittedCount")).receivedCount(this.getProcessorMetricSum(jobId, vertex.id, lastExecutionId, processorId, store, "receivedCount")).lastForwardedWmLatency(lastForwardedWmLatency).capPercentage(df.format((float)(queueSize * 100L) / ((float)queueCapacity * 1.0f))).build();
    }

    private long getProcessorMetricSum(String jobId, String vertex, String lastExecutionId, int processorId, JetClusterMetricsStore store, String metric) {
        ArrayList<TagExpression> tags = new ArrayList<TagExpression>(Arrays.asList(TagExpressions.tagEquals((String)"job", (String)jobId), TagExpressions.tagEquals((String)"vertex", (String)vertex), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagEquals((String)"proc", (String)String.valueOf(processorId)), TagExpressions.tagNotEquals((String)"ordinal", (String)"snapshot")));
        if ("receivedCount".equals(metric)) {
            tags.add((TagExpression)TagExpressions.tagNotEquals((String)"source", (String)"true"));
        }
        return store.query(metric, (TagExpression)TagExpressions.and(tags)).mapToLong(TimeSeries::queryLast).sum();
    }

    private long getProcessorMetric(String jobId, String vertex, String lastExecutionId, int processorId, JetClusterMetricsStore store, String metric) {
        return store.querySingle(metric, (TagExpression)TagExpressions.and((TagExpression[])new TagExpression[]{TagExpressions.tagEquals((String)"job", (String)jobId), TagExpressions.tagEquals((String)"vertex", (String)vertex), TagExpressions.tagEquals((String)"exec", (String)lastExecutionId), TagExpressions.tagEquals((String)"proc", (String)String.valueOf(processorId)), TagExpressions.tagNull((String)"ordinal")})).queryLast(-1L);
    }
}

