/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class MapQueryCacheConsistencyAnalyzer
extends SemanticConfigAnalyzer {
    MapQueryCacheConsistencyAnalyzer(MemberConfigSupplier memberConfigs) {
        super(memberConfigs);
    }

    protected List<Problem> analyze(MemberConfig config) {
        return config.toEffectiveConfig().getMapConfigs().values().stream().map(arg_0 -> this.analyze(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Problem> analyze(MapConfig mapConfig) {
        return mapConfig.getQueryCacheConfigs().stream().filter(queryCache -> queryCache.getDelaySeconds() == 0).filter(queryCache -> queryCache.getBatchSize() > 1).map(queryCache -> new ClusterWideProblem(String.format("Query cache %s of map %s is configured for batch updates while delay-seconds is 0", queryCache.getName(), mapConfig.getName()), "Either set a positive delay-seconds value or set batch-size to 1")).collect(Collectors.toList());
    }

    public String describeSelf() {
        return "Checking if Map query caches configured with batch updates have higher than 0 delay-seconds";
    }
}

