/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.ArrayList;
import java.util.List;

class MapBackupReadEvictionAnalyzer
extends SemanticConfigAnalyzer {
    MapBackupReadEvictionAnalyzer(MemberConfigSupplier memberConfigs) {
        super(memberConfigs);
    }

    protected List<Problem> analyze(MemberConfig config) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (MapConfig mapConfig : config.toEffectiveConfig().getMapConfigs().values()) {
            if (!mapConfig.isReadBackupData() || !this.isEvictionEnabled(mapConfig)) continue;
            String mapName = mapConfig.getName();
            problems.add((Problem)new ClusterWideProblem(String.format("Backup reads are enabled for map %s. Backup reads are not reflected on the primary member, therefore entries can expire, regardless if they are read on a backup partition.", mapName), String.format("Turn off backup reads for map %s", mapName)));
        }
        return problems;
    }

    private boolean isEvictionEnabled(MapConfig mapConfig) {
        return mapConfig.getEvictionConfig() != null && mapConfig.getEvictionConfig().getEvictionPolicy() != EvictionPolicy.NONE || mapConfig.getMaxIdleSeconds() > 0;
    }

    public String describeSelf() {
        return "Checking if backup reads are disabled for maps with TTL-based eviction";
    }
}

