/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class EvictionEquivalence
extends AttributeEquivalence<EvictionConfig> {
    private final String displayedAttributeAccessPath;

    EvictionEquivalence(Map<EvictionConfig, Set<MemberIdentifier>> groupsByValues, String ownerObjectDescription) {
        this(groupsByValues, ownerObjectDescription, "eviction");
    }

    EvictionEquivalence(Map<EvictionConfig, Set<MemberIdentifier>> groupsByValues, String ownerObjectDescription, String displayedAttributeAccessPath) {
        super(groupsByValues, ownerObjectDescription);
        this.displayedAttributeAccessPath = displayedAttributeAccessPath;
    }

    protected <A> void checkSimpleAttributeEquality(Function<EvictionConfig, A> attributeExtractor, String attributeDisplayedName) {
        this.compareEntryAttributes(attributeExtractor, i -> attributeDisplayedName + " is " + i, () -> MemberComparisonProblem.builder().description(String.format("The %s attribute is inconsistent across member configurations for %s", attributeDisplayedName, this.ownerObjectDescription)).advice(String.format("Set the same %s attribute in all member configurations", attributeDisplayedName)));
    }

    void compareEntries() {
        this.checkSimpleAttributeEquality(EvictionConfig::getEvictionPolicy, this.displayedAttributeAccessPath + ".eviction-policy");
        this.checkSimpleAttributeEquality(EvictionConfig::getMaxSizePolicy, this.displayedAttributeAccessPath + ".max-size-policy");
        this.checkSimpleAttributeEquality(EvictionConfig::getSize, this.displayedAttributeAccessPath + ".size");
        this.checkSimpleAttributeEquality(EvictionConfig::getComparatorClassName, this.displayedAttributeAccessPath + ".comparator-class-name");
    }
}

