/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.controller.dto.healthcheck.AddIgnoreListEntryRequestDTO;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckListener;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreListEntryAlreadyExistsException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

public class EventPublishingHealthCheckService
implements HealthCheckService {
    private final HealthCheckService delegate;
    private final List<HealthCheckListener> listeners;

    public List<AnalysisOutcome> analyze(String cluster) {
        List outcomes = this.delegate.analyze(cluster);
        int foundProblemCount = outcomes.stream().mapToInt(outcome -> outcome.getIdentifiedProblems().size()).sum();
        this.listeners.forEach(listener -> listener.healthCheckRan(foundProblemCount));
        return outcomes;
    }

    public void addIgnoreListEntry(String cluster, AddIgnoreListEntryRequestDTO request) throws IgnoreListEntryAlreadyExistsException {
        this.delegate.addIgnoreListEntry(cluster, request);
        this.listeners.forEach(HealthCheckListener::healthCheckIgnoreListEntryAdded);
    }

    @ConstructorProperties(value={"delegate", "listeners"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EventPublishingHealthCheckService(HealthCheckService delegate, List<HealthCheckListener> listeners) {
        this.delegate = delegate;
        this.listeners = listeners;
    }
}

