/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.DeviceConfig;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AbstractDeviceAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberMetricsSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.PercentageUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeviceCapacityAnalyzer
extends AbstractDeviceAnalyzer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceCapacityAnalyzer.class);
    public static final String DEVICE_CAPACITY_ANALYZER_DESCRIPTION = "Tiered Storage: checking if member device capacities are valid";
    public static final String DEVICE_CAPACITY_ANALYZER_ADVICE = "Please set your device capacity configuration to a smaller value";

    public DeviceCapacityAnalyzer(MemberConfigSupplier memberConfigs, MemberMetricsSupplier memberMetrics) {
        super(memberConfigs, memberMetrics);
    }

    protected Optional<MemberProblem> getMemberProblem(MemberIdentifier memberIdentifier, String deviceName, DeviceConfig deviceConfig, MetricDataPoint metricDataPoint) {
        long deviceConfigCapacity = deviceConfig.getCapacity().bytes();
        long deviceCapacity = metricDataPoint.getValue();
        log.trace("Member {} device {} has device config vs actual capacity {}<>{}", new Object[]{memberIdentifier, deviceName, deviceConfigCapacity, deviceCapacity});
        if (deviceConfigCapacity > deviceCapacity) {
            String baseDirPath = DeviceCapacityAnalyzer.getDeviceBaseDirOrNull((DeviceConfig)deviceConfig);
            MemberProblem problem = DeviceCapacityAnalyzer.deviceCapacityMemberProblem((MemberIdentifier)memberIdentifier, (long)deviceConfigCapacity, (long)deviceCapacity, (String)deviceName, (String)baseDirPath);
            log.debug(problem.getDescription());
            return Optional.of(problem);
        }
        return Optional.empty();
    }

    public String describeSelf() {
        return "Tiered Storage: checking if member device capacities are valid";
    }

    public static MemberProblem deviceCapacityMemberProblem(MemberIdentifier memberIdentifier, long deviceConfigCapacity, long deviceCapacity, String deviceName, String baseDirPath) {
        String description = String.format("Tiered Storage: the configured device capacity of %,d bytes is greater than the actual device capacity of %,d bytes (over by %,.2f%%) for device %s", deviceConfigCapacity, deviceCapacity, PercentageUtils.calculateExcessInPercentage((long)deviceConfigCapacity, (long)deviceCapacity), deviceName);
        if (baseDirPath != null) {
            description = description + " at base directory " + baseDirPath;
        }
        return new MemberProblem(description, "Please set your device capacity configuration to a smaller value", memberIdentifier);
    }
}

