/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigMap;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberMetricsSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeviceAnalyzer
implements Analyzer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDeviceAnalyzer.class);
    private final MemberConfigSupplier memberConfigs;
    private final MemberMetricsSupplier memberMetrics;

    public AnalysisOutcome analyze(SourceDataFilter filter) {
        ArrayList warnings = new ArrayList();
        filter.filter((Map)this.memberMetrics.get()).forEach((memberIdentifier, metricDataPointList) -> {
            if (metricDataPointList != null) {
                Optional.ofNullable((MemberConfig)((MemberConfigMap)this.memberConfigs.get()).get(memberIdentifier)).map(MemberConfig::toEffectiveConfig).map(Config::getDeviceConfigs).ifPresent(deviceConfigMap -> deviceConfigMap.forEach((deviceName, deviceConfig) -> metricDataPointList.forEach(metricDataPoint -> metricDataPoint.getTags().getTag("name").filter(tag -> deviceName.equals(tag.getValue())).flatMap(tag -> this.getMemberProblem(memberIdentifier, deviceName, deviceConfig, metricDataPoint)).ifPresent(warnings::add))));
            }
        });
        return AnalysisOutcome.warning((String)this.describeSelf(), warnings);
    }

    protected abstract Optional<MemberProblem> getMemberProblem(MemberIdentifier var1, String var2, DeviceConfig var3, MetricDataPoint var4);

    static String getDeviceBaseDirOrNull(DeviceConfig deviceConfig) {
        File baseDir;
        String baseDirPath = null;
        if (deviceConfig instanceof LocalDeviceConfig && (baseDir = ((LocalDeviceConfig)deviceConfig).getBaseDir()) != null) {
            baseDirPath = baseDir.getAbsolutePath();
        }
        return baseDirPath;
    }

    @ConstructorProperties(value={"memberConfigs", "memberMetrics"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractDeviceAnalyzer(MemberConfigSupplier memberConfigs, MemberMetricsSupplier memberMetrics) {
        this.memberConfigs = memberConfigs;
        this.memberMetrics = memberMetrics;
    }
}

