/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.client_filtering;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.webmonitor.service.ClusterClientFilteringDTO;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.client.MCClient;

public class ClientFilteringSharedSource {
    public static final String CLIENT_FILTERING_MAP = "__mc.clientFiltering";
    public static final String DEPLOYED_FILTERS_KEY = "deployedClientFilters";
    private final MCClientManager mcClientManager;

    public ClientFilteringSharedSource(MCClientManager mcClientManager) {
        this.mcClientManager = mcClientManager;
    }

    public ClusterClientFilteringDTO get(String clusterName) {
        IMap clientFilteringMap = this.getClientFilteringMapForCluster(clusterName);
        return (ClusterClientFilteringDTO)clientFilteringMap.get((Object)DEPLOYED_FILTERS_KEY);
    }

    public ClusterClientFilteringDTO put(String clusterName, ClusterClientFilteringDTO localConfig) {
        IMap clientFilteringMap = this.getClientFilteringMapForCluster(clusterName);
        return (ClusterClientFilteringDTO)clientFilteringMap.put((Object)DEPLOYED_FILTERS_KEY, (Object)localConfig);
    }

    public ClusterClientFilteringDTO putIfAbsent(String clusterName, ClusterClientFilteringDTO localConfig) {
        IMap clientFilteringMap = this.getClientFilteringMapForCluster(clusterName);
        return (ClusterClientFilteringDTO)clientFilteringMap.putIfAbsent((Object)DEPLOYED_FILTERS_KEY, (Object)localConfig);
    }

    public void delete(String clusterName) {
        this.getClientFilteringMapForCluster(clusterName).delete((Object)DEPLOYED_FILTERS_KEY);
    }

    private IMap<String, ClusterClientFilteringDTO> getClientFilteringMapForCluster(String clusterName) {
        MCClient client = this.mcClientManager.clientFor(clusterName);
        HazelcastInstance imdgClient = client.getHzClient();
        return imdgClient.getMap(CLIENT_FILTERING_MAP);
    }
}

